/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal;

import static java.util.Optional.empty;

import org.mule.runtime.module.extension.api.loader.java.type.FieldElement;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.VariableElement;

import java.lang.reflect.Field;
import java.util.Optional;


/**
 * @since 1.0
 */
public class FieldTypeElement extends VariableElementAST implements FieldElement {

  public FieldTypeElement(VariableElement elem, ProcessingEnvironment processingEnvironment) {
    super(elem, processingEnvironment);
  }

  @Override
  public Optional<Field> getField() {
    return empty();
  }

  @Override
  public String getOwnerDescription() {
    return "Class";
  }

}
