/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal;

import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.Types;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.ast.api.IntrospectionContext;
import org.mule.metadata.ast.api.TypeHandler;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.runtime.parameter.Literal;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;

public class ExtensionTypeHandler
implements TypeHandler {
    private ProcessingEnvironment processingEnvironment;

    public ExtensionTypeHandler(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
    }

    public boolean handles(TypeMirror typeMirror) {
        return typeMirror instanceof DeclaredType && this.isHandled(typeMirror);
    }

    private boolean isHandled(TypeMirror typeMirror) {
        return this.isSameType(typeMirror, TypedValue.class) || this.isSameType(typeMirror, ParameterResolver.class) || this.isSameType(typeMirror, Literal.class);
    }

    public TypeBuilder<?> handle(TypeMirror typeMirror, TypeVisitor<TypeBuilder<?>, IntrospectionContext> typeVisitor, IntrospectionContext context) {
        if (typeMirror instanceof DeclaredType && this.isHandled(typeMirror)) {
            List<? extends TypeMirror> typeArguments = ((DeclaredType)typeMirror).getTypeArguments();
            if (typeArguments.isEmpty()) {
                throw new IllegalArgumentException("The given TypeMirror " + typeMirror + " doesn't provide generics");
            }
            return typeArguments.get(0).accept(typeVisitor, context);
        }
        throw new IllegalArgumentException("The given TypeMirror " + typeMirror + " it's not supported by this Handler");
    }

    public boolean isSameType(TypeMirror typeMirror, Class aClass) {
        Types types = this.processingEnvironment.getTypeUtils();
        TypeMirror erasure = types.erasure(typeMirror);
        TypeMirror clazz = types.erasure(this.processingEnvironment.getElementUtils().getTypeElement(aClass.getName()).asType());
        return types.isSameType(erasure, clazz);
    }
}

