/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.extension.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.extension.internal.ASTType;
import org.mule.runtime.ast.extension.internal.ASTUtils;
import org.mule.runtime.ast.extension.internal.ElementASTUtils;
import org.mule.runtime.ast.extension.internal.MethodParameterElementAST;
import org.mule.runtime.ast.extension.internal.OperationContainerElementAST;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;

public class MethodElementAST<T extends Type>
implements MethodElement<T> {
    private final LazyValue<List<ExtensionParameter>> parameters;
    private final LazyValue<List<ExtensionParameter>> parameterGroups;
    private final ASTUtils astUtils;
    protected final ProcessingEnvironment processingEnvironment;
    protected final ExecutableElement method;

    MethodElementAST(ExecutableElement method, ProcessingEnvironment processingEnvironment) {
        this.method = method;
        this.processingEnvironment = processingEnvironment;
        this.astUtils = new ASTUtils(processingEnvironment);
        this.parameters = new LazyValue(() -> method.getParameters().stream().map(param -> new MethodParameterElementAST((VariableElement)param, processingEnvironment)).collect(Collectors.toList()));
        this.parameterGroups = new LazyValue(() -> ElementASTUtils.getParameterGroupExtensionParameters(this));
    }

    public Optional<Method> getMethod() {
        return Optional.empty();
    }

    public List<Type> getExceptionTypes() {
        return this.method.getThrownTypes().stream().map(type -> new ASTType((TypeMirror)type, this.processingEnvironment)).collect(Collectors.toList());
    }

    public T getEnclosingType() {
        return (T)new OperationContainerElementAST((TypeElement)this.method.getEnclosingElement(), this.processingEnvironment);
    }

    public List<ExtensionParameter> getParameters() {
        return (List)this.parameters.get();
    }

    public List<ExtensionParameter> getParameterGroups() {
        return (List)this.parameterGroups.get();
    }

    public List<ExtensionParameter> getParametersAnnotatedWith(Class<? extends Annotation> annotationClass) {
        return this.getParameters().stream().filter(param -> param.isAnnotatedWith(annotationClass)).collect(Collectors.toList());
    }

    public ASTType getReturnType() {
        return new ASTType(this.method.getReturnType(), this.processingEnvironment);
    }

    public String getName() {
        return this.method.getSimpleName().toString();
    }

    public <A extends Annotation> Optional<A> getAnnotation(Class<A> annotationClass) {
        return Optional.ofNullable(this.method.getAnnotation(annotationClass));
    }

    public boolean isAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.method != null && this.method.getAnnotation(annotation) != null;
    }

    public <A extends Annotation> Optional<AnnotationValueFetcher<A>> getValueFromAnnotation(Class<A> annotationClass) {
        return this.isAnnotatedWith(annotationClass) ? Optional.of(this.astUtils.fromAnnotation(annotationClass, this.method)) : Optional.empty();
    }

    public Stream<Type> getAnnotations() {
        return this.method.getAnnotationMirrors().stream().map(ann -> new ASTType(ann.getAnnotationType(), this.processingEnvironment));
    }

    public Optional<Class<?>> getDeclaringClass() {
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodElementAST that = (MethodElementAST)o;
        return Objects.equals(that.method, this.method);
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public Optional<ExecutableElement> getElement() {
        return Optional.of(this.method);
    }
}

