/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.extension.internal;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.mule.runtime.ast.extension.internal.ASTValueFetcher;

class ASTUtils {
    private final ProcessingEnvironment processingEnvironment;
    private final Map<String, TypeMirror> primitiveTypeMirrors = new HashMap<String, TypeMirror>();

    ASTUtils(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
        this.primitiveTypeMirrors.put("int", processingEnvironment.getTypeUtils().getPrimitiveType(TypeKind.INT));
        this.primitiveTypeMirrors.put("long", processingEnvironment.getTypeUtils().getPrimitiveType(TypeKind.LONG));
        this.primitiveTypeMirrors.put("double", processingEnvironment.getTypeUtils().getPrimitiveType(TypeKind.DOUBLE));
        this.primitiveTypeMirrors.put("float", processingEnvironment.getTypeUtils().getPrimitiveType(TypeKind.FLOAT));
        this.primitiveTypeMirrors.put("boolean", processingEnvironment.getTypeUtils().getPrimitiveType(TypeKind.BOOLEAN));
        this.primitiveTypeMirrors.put("char", processingEnvironment.getTypeUtils().getPrimitiveType(TypeKind.CHAR));
        this.primitiveTypeMirrors.put("byte", processingEnvironment.getTypeUtils().getPrimitiveType(TypeKind.BYTE));
        this.primitiveTypeMirrors.put("void", processingEnvironment.getTypeUtils().getNoType(TypeKind.VOID));
        this.primitiveTypeMirrors.put("short", processingEnvironment.getTypeUtils().getPrimitiveType(TypeKind.SHORT));
    }

    <T extends Annotation> ASTValueFetcher<T> fromAnnotation(Class<T> annotationClass, Element element) {
        return new ASTValueFetcher<T>(annotationClass, element, this.processingEnvironment);
    }

    Optional<TypeMirror> getPrimitiveTypeMirror(Class<?> clazz) {
        return Optional.ofNullable(this.primitiveTypeMirrors.get(clazz.getTypeName()));
    }
}

