/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.commons.internal;

import java.io.File;
import org.mule.runtime.module.embedded.commons.api.ArtifactConfiguration;
import org.mule.runtime.module.embedded.commons.api.DeploymentConfiguration;
import org.mule.runtime.module.embedded.commons.internal.utils.Preconditions;

public class DefaultArtifactConfigurationBuilder
implements ArtifactConfiguration.ArtifactConfigurationBuilder {
    private File applicationLocation;
    private DeploymentConfiguration deploymentConfiguration = DeploymentConfiguration.builder().build();

    @Override
    public ArtifactConfiguration.ArtifactConfigurationBuilder artifactLocation(File artifactLocation) {
        this.applicationLocation = artifactLocation;
        return this;
    }

    @Override
    public ArtifactConfiguration.ArtifactConfigurationBuilder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
        this.deploymentConfiguration = deploymentConfiguration;
        return this;
    }

    @Override
    public ArtifactConfiguration build() {
        return new ArtifactConfigurationImpl(this.deploymentConfiguration, this.applicationLocation);
    }

    static class ArtifactConfigurationImpl
    implements ArtifactConfiguration {
        private static final long serialVersionUID = -4039186436472162679L;
        private DeploymentConfiguration deploymentConfiguration;
        private File applicationLocation;

        public ArtifactConfigurationImpl(DeploymentConfiguration deploymentConfiguration, File applicationLocation) {
            Preconditions.checkArgument(deploymentConfiguration != null, "deploymentConfiguration cannot be null");
            Preconditions.checkArgument(applicationLocation != null, "applicationLocation cannot be null");
            this.deploymentConfiguration = deploymentConfiguration;
            this.applicationLocation = applicationLocation;
        }

        @Override
        public DeploymentConfiguration getDeploymentConfiguration() {
            return this.deploymentConfiguration;
        }

        @Override
        public File getArtifactLocation() {
            return this.applicationLocation;
        }
    }
}

