/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.embedded.commons.api;

import java.io.Serializable;
import java.net.URL;
import java.util.List;

/**
 * This class contains all the information related to the container resources.
 *
 * @since 1.8, 1.7.2, 1.6.6
 */
public class ContainerInfo implements Serializable {

  private static final long serialVersionUID = -4933503680829251207L;

  private final String version;
  private final URL containerBaseFolder;
  private final List<URL> services;
  private final List<URL> serverPlugins;
  private String log4jConfigurationFile;

  /**
   * Creates a new instance.
   *
   * @param version             the version of the mule runtime to use.
   * @param containerBaseFolder the container base folder to use for placing container resources.
   * @param services            the list of services to load within the container.
   * @param serverPlugins       the list of services plugins to load within the container.
   */
  public ContainerInfo(String version, URL containerBaseFolder, List<URL> services, List<URL> serverPlugins) {
    this.version = version;
    this.containerBaseFolder = containerBaseFolder;
    this.services = services;
    this.serverPlugins = serverPlugins;
  }

  /**
   * @return the runtime version to use
   */
  public String getVersion() {
    return version;
  }

  /**
   * @return the folder to use to create container resources
   */
  public URL getContainerBaseFolder() {
    return containerBaseFolder;
  }

  /**
   * @return the list of services to load in the container
   */
  public List<URL> getServices() {
    return services;
  }

  /**
   * @return the list of services plugins to load within the container.
   */
  public List<URL> getServerPlugins() {
    return serverPlugins;
  }
}
