/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.runtime.module.embedded.api.dependencies.DependencyResolver;
import org.mule.runtime.module.embedded.api.dependencies.MuleDependenciesResolver;
import org.mule.runtime.module.embedded.internal.utils.DependenciesUtils;

public class LocalDistroMuleDependenciesResolver
implements MuleDependenciesResolver {
    private static final String BOOT_DIR = "lib/boot";
    private static final String MULE_DIR = "lib/mule";
    private static final String OPT_DIR = "lib/opt";
    private static final String SERVICES_DIR = "services";
    private static final String SERVER_PLUGINS_DIR = "server-plugins";
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final List<String> EXCLUDED_OPT_LIBS_FROM_BOOT = Arrays.asList("disruptor", "log4j");
    private static final String MULE_LIBS_PREFIX = "mule-module";
    private final Path localDistributionPath;
    private final List<BundleDescriptor> serverPlugins;
    private final DependencyResolver dependencyResolver;
    private final boolean sanitize;
    private List<URL> containerUrls;
    private List<URL> muleUrls;
    private List<URL> optUrls;
    private List<URL> servicesUrls;
    private List<URL> serverPluginsUrls;

    public LocalDistroMuleDependenciesResolver(Path localDistributionPath) {
        this(localDistributionPath, Collections.emptyList(), null, true);
    }

    public LocalDistroMuleDependenciesResolver(Path localDistributionPath, List<BundleDescriptor> serverPlugins, DependencyResolver dependencyResolver, boolean sanitize) {
        if (!Files.isDirectory(localDistributionPath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Local distribution path '%s' is not a directory", localDistributionPath));
        }
        this.localDistributionPath = localDistributionPath;
        this.serverPlugins = serverPlugins;
        this.dependencyResolver = dependencyResolver;
        this.sanitize = sanitize;
    }

    @Override
    public List<URL> resolveMuleLibs() {
        if (this.containerUrls == null) {
            this.resolveContainerUrls();
        }
        return this.muleUrls;
    }

    @Override
    public List<URL> resolveOptLibs() {
        if (this.containerUrls == null) {
            this.resolveContainerUrls();
        }
        return this.optUrls;
    }

    @Override
    public List<URL> resolveMuleServices() {
        if (this.servicesUrls == null) {
            this.servicesUrls = this.getDirectoriesFromPath(this.localDistributionPath.resolve(SERVICES_DIR));
        }
        return this.servicesUrls;
    }

    @Override
    public List<URL> resolveServerPlugins() {
        if (this.serverPluginsUrls == null) {
            this.serverPluginsUrls = this.getDirectoriesFromPath(this.localDistributionPath.resolve(SERVER_PLUGINS_DIR));
            this.serverPluginsUrls.addAll(this.serverPlugins.stream().map(this.dependencyResolver::resolveBundleDescriptor).map(DependenciesUtils.dependencyToUrl()).collect(Collectors.toList()));
        }
        return this.serverPluginsUrls;
    }

    private List<URL> getDirectoriesFromPath(Path path) {
        ArrayList<URL> directories = new ArrayList<URL>();
        try (Stream<Path> paths = Files.walk(path, 1, new FileVisitOption[0]);){
            paths.skip(1L).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(serviceDir -> directories.add(this.pathToUrl((Path)serviceDir)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return directories;
    }

    private void resolveContainerUrls() {
        Map<Boolean, List<URL>> partitionedBootLibs = this.libsFromDirectory(this.localDistributionPath.resolve(BOOT_DIR)).stream().collect(Collectors.partitioningBy(this::isMuleLib));
        this.muleUrls = this.libsFromDirectory(this.localDistributionPath.resolve(MULE_DIR));
        this.muleUrls.addAll((Collection<URL>)partitionedBootLibs.get(true));
        this.optUrls = this.libsFromDirectory(this.localDistributionPath.resolve(OPT_DIR));
        this.optUrls.addAll(partitionedBootLibs.get(false).stream().filter(this::sanitizeOptDependencies).collect(Collectors.toList()));
        this.containerUrls = new ArrayList<URL>(this.muleUrls);
        this.containerUrls.addAll(this.optUrls);
    }

    private boolean sanitizeOptDependencies(URL jar) {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17) && this.sanitize) {
            return EXCLUDED_OPT_LIBS_FROM_BOOT.stream().noneMatch(excludedLib -> jar.toString().contains((CharSequence)excludedLib));
        }
        return true;
    }

    private boolean isMuleLib(URL jar) {
        return Paths.get(this.urlToUri(jar)).getFileName().toString().startsWith(MULE_LIBS_PREFIX);
    }

    private List<URL> libsFromDirectory(Path directory) {
        List<URL> list;
        block9: {
            if (!Files.exists(directory, new LinkOption[0]) || !Files.isDirectory(directory, new LinkOption[0])) {
                throw new RuntimeException(String.format("Invalid distribution directory structure. Couldn't find '%s'", directory));
            }
            Stream<Path> paths = Files.walk(directory, new FileVisitOption[0]);
            try {
                list = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(this::shouldKeepXmlApis).filter(path -> path.toString().endsWith(JAR_FILE_EXTENSION)).map(p -> {
                    try {
                        return p.toUri().toURL();
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }).collect(Collectors.toList());
                if (paths == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            paths.close();
        }
        return list;
    }

    private URL pathToUrl(Path path) {
        try {
            return path.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private URI urlToUri(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean shouldKeepXmlApis(Path jar) {
        if (SystemUtils.IS_JAVA_1_8) {
            return true;
        }
        return !jar.toString().contains("xml-apis");
    }
}

