/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.mule.maven.client.api.BundleDependenciesResolutionException;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.runtime.jpms.api.JpmsUtils;
import org.mule.runtime.jpms.api.MultiLevelClassLoaderFactory;
import org.mule.runtime.module.embedded.internal.MavenContainerClassLoaderFactory;
import org.mule.runtime.module.embedded.internal.RuntimeProduct;
import org.mule.runtime.module.embedded.internal.utils.Preconditions;

public class MavenContainerOptSeparateClassLoaderFactory
extends MavenContainerClassLoaderFactory {
    private static final Collection<ExcludedDependency> EXCLUDED_DEPENDENCIES = new ArrayList<ExcludedDependency>();

    public MavenContainerOptSeparateClassLoaderFactory(MavenClient mavenClient) {
        super(mavenClient);
    }

    @Override
    public ClassLoader create(RuntimeProduct runtimeProduct, URL containerBaseFolder) {
        try {
            List<BundleDependency> bundleDependencies = this.resolveDependencies(runtimeProduct);
            Map<Boolean, List<BundleDependency>> partitionedDependencies = bundleDependencies.stream().collect(Collectors.partitioningBy(bundleDependency -> this.isMuleContainerGroupId(bundleDependency.getDescriptor().getGroupId())));
            List<URL> muleUrls = partitionedDependencies.get(true).stream().map(this.dependencyToUrl()).collect(Collectors.toList());
            List<URL> optUrls = partitionedDependencies.get(false).stream().filter(this::sanitizeOptDependencies).map(this.dependencyToUrl()).collect(Collectors.toList());
            File containerFolderFile = FileUtils.toFile((URL)containerBaseFolder);
            URL configurationFolderUrl = new URL(new File(containerFolderFile, "conf").toURI() + "/");
            URLClassLoader parentClassLoader = new URLClassLoader(Collections.singletonList(configurationFolderUrl).toArray(new URL[1]), this.buildParentClassLoader(this.getClass().getClassLoader()));
            return JpmsUtils.createModuleLayerClassLoader((URL[])optUrls.toArray(new URL[optUrls.size()]), (URL[])muleUrls.toArray(new URL[muleUrls.size()]), (MultiLevelClassLoaderFactory)MultiLevelClassLoaderFactory.MULTI_LEVEL_URL_CLASSLOADER_FACTORY, (ClassLoader)parentClassLoader, Optional.of(this.getClass()));
        }
        catch (BundleDependenciesResolutionException e) {
            throw new IllegalArgumentException("Could not find embedded container bom artifact", e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean sanitizeOptDependencies(BundleDependency bundleDependency) {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17)) {
            return EXCLUDED_DEPENDENCIES.stream().noneMatch(excludedDependency -> excludedDependency.match(bundleDependency));
        }
        return true;
    }

    private boolean isMuleContainerGroupId(String groupId) {
        return groupId.equals("org.mule.runtime") || groupId.equals("org.mule.runtime.boot") || groupId.equals("org.mule.sdk") || groupId.equals("org.mule.weave") || groupId.equals("org.mule.mvel") || groupId.equals("org.mule.commons") || groupId.equals("com.mulesoft.mule.runtime") || groupId.equals("com.mulesoft.mule.runtime.boot") || groupId.equals("com.mulesoft.mule.runtime.modules") || groupId.equals("com.mulesoft.anypoint");
    }

    static {
        EXCLUDED_DEPENDENCIES.add(new ExcludedDependency("org.apache.logging.log4j"));
        EXCLUDED_DEPENDENCIES.add(new ExcludedDependency("com.lmax", "disruptor"));
    }

    private static class ExcludedDependency {
        private final String groupId;
        private final String artifactId;

        public ExcludedDependency(String groupId) {
            this(groupId, null);
        }

        public ExcludedDependency(String groupId, String artifactId) {
            Preconditions.checkArgument(groupId != null, "'groupId' can't be null");
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public boolean match(BundleDependency bundleDependency) {
            boolean match = this.groupId.equals(bundleDependency.getDescriptor().getGroupId());
            if (this.artifactId != null) {
                match = match && this.artifactId.equals(bundleDependency.getDescriptor().getArtifactId());
            }
            return match;
        }
    }
}

