/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.util.Preconditions;
import org.mule.runtime.module.embedded.api.ContainerConfiguration;

public class DefaultContainerConfigurationBuilder
implements ContainerConfiguration.ContainerConfigurationBuilder {
    private File containerFolder;
    private List<BundleDescriptor> bundleDescriptors = new ArrayList<BundleDescriptor>();

    @Override
    public ContainerConfiguration.ContainerConfigurationBuilder containerFolder(File containerFolder) {
        this.containerFolder = containerFolder;
        return this;
    }

    @Override
    public ContainerConfiguration.ContainerConfigurationBuilder serverPlugins(BundleDescriptor ... bundleDescriptors) {
        this.bundleDescriptors = Arrays.asList(bundleDescriptors);
        return this;
    }

    @Override
    public ContainerConfiguration.ContainerConfigurationBuilder serverPlugins(List<BundleDescriptor> bundleDescriptors) {
        this.bundleDescriptors = Collections.unmodifiableList(bundleDescriptors);
        return this;
    }

    @Override
    public ContainerConfiguration build() {
        return new ContainerConfigurationImpl(this.containerFolder, this.bundleDescriptors);
    }

    public static class ContainerConfigurationImpl
    implements ContainerConfiguration {
        private static final long serialVersionUID = -560574823186446469L;
        private File containerFolder;
        private List<BundleDescriptor> serverPlugins;

        public ContainerConfigurationImpl(File containerFolder, List<BundleDescriptor> serverPlugins) {
            Preconditions.checkNotNull((Object)containerFolder, (String)"containerFolder cannot be null");
            Preconditions.checkNotNull(serverPlugins, (String)"serverPlugins cannot be null");
            this.containerFolder = containerFolder;
            this.serverPlugins = serverPlugins;
        }

        @Override
        public File getContainerFolder() {
            return this.containerFolder;
        }

        @Override
        public List<BundleDescriptor> getServerPlugins() {
            return this.serverPlugins;
        }
    }
}

