/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.embedded.api;

import org.mule.api.annotation.NoImplement;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.runtime.module.embedded.internal.DefaultContainerConfigurationBuilder;

import java.io.File;
import java.io.Serializable;
import java.util.List;

/**
 * Configuration related to the container.
 *
 * @since 1.0
 */
@NoImplement
public interface ContainerConfiguration extends Serializable {

  /**
   * Defines the location where the mule container folders will be contained.
   * <p>
   * It may contain pre-configured files for the runtime and the container may create additional files, but disposal of the folder
   * after using the embedded container is up to the client.
   *
   * @return location of the container folder.
   */
  File getContainerFolder();

  /**
   * @return collection of server plugins to be started with the container
   */
  List<BundleDescriptor> getServerPlugins();

  /**
   * @return a new builder to create an {@link ContainerConfigurationBuilder} instance.
   */
  static ContainerConfigurationBuilder builder() {
    return new DefaultContainerConfigurationBuilder();
  }

  /**
   * Builder interface to create instances of {@link ArtifactConfiguration}.
   */
  interface ContainerConfigurationBuilder {

    /**
     * @param containerFolder location of the container folder.
     * @return same builder
     */
    ContainerConfigurationBuilder containerFolder(File containerFolder);

    /**
     * @param bundleDescriptors collection of server plugins to be started with the container
     * @return same builder
     */
    ContainerConfigurationBuilder serverPlugins(BundleDescriptor... bundleDescriptors);

    /**
     * @param bundleDescriptors collection of server plugins to be started with the container
     * @return same builder
     */
    ContainerConfigurationBuilder serverPlugins(List<BundleDescriptor> bundleDescriptors);

    /**
     * @return a new instance of {@link ContainerConfiguration} with the provided configuration.
     */
    ContainerConfiguration build();

  }



}
