/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.embedded.api.dependencies;

import org.mule.api.annotation.NoImplement;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;

import java.util.List;

/**
 * Provides access to the underlying dependency resolution mechanism to resolve the dependencies of artifacts.
 *
 * @since 1.8
 */
@NoImplement
public interface DependencyResolver {

  /**
   * Uses a dependency resolution mechanism to resolve the dependencies for an artifact.
   *
   * @param descriptor the descriptor of the artifact to resolve dependencies for.
   * @return an object containing the dependencies for the provided artifact.
   *
   */
  List<BundleDependency> resolveBundleDescriptorDependencies(BundleDescriptor descriptor);

  /**
   * Uses a dependency resolution mechanism to resolve the dependency corresponding to the given {@link BundleDescriptor}.
   *
   * @param descriptor the descriptor of the artifact whose dependency is to be resolved.
   * @return the provided artifact's dependency.
   *
   */
  BundleDependency resolveBundleDescriptor(BundleDescriptor descriptor);

}
