/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.embedded.internal.controller;

import static java.lang.String.format;

import org.mule.runtime.module.embedded.api.ContainerInfo;

import java.util.Iterator;
import java.util.ServiceLoader;

/**
 * API to find the implementation for the {@link EmbeddedController}.
 *
 * @since 1.5
 * @deprecated since 1.6 use {@link org.mule.runtime.module.embedded.api.controller.EmbeddedControllerProvider}.
 */
@Deprecated
public interface EmbeddedControllerProvider extends org.mule.runtime.module.embedded.api.controller.EmbeddedControllerProvider {

  EmbeddedController createEmbeddedController(ContainerInfo containerInfo);

  /**
   * Discovers an available {@link EmbeddedControllerProvider}.
   *
   * @return a new client configured with the provided maven configuration.
   */
  static EmbeddedControllerProvider discoverProvider() {
    return discoverProvider(EmbeddedControllerProvider.class.getClassLoader());
  }

  /**
   * Discovers an available {@link EmbeddedControllerProvider}.
   *
   * @param classLoader class loader from where to load the provider.
   * @return a new client configured with the provided maven configuration.
   */
  static EmbeddedControllerProvider discoverProvider(ClassLoader classLoader) {
    ServiceLoader<EmbeddedControllerProvider> factories =
        ServiceLoader.load(EmbeddedControllerProvider.class, classLoader);
    Iterator<EmbeddedControllerProvider> iterator = factories.iterator();
    if (!iterator.hasNext()) {
      throw new IllegalStateException(format("Could not find %s service implementation through SPI",
                                             EmbeddedControllerProvider.class.getName()));
    }

    EmbeddedControllerProvider embeddedControllerProvider = iterator.next();

    if (iterator.hasNext()) {
      throw new IllegalStateException(format("Found more than one %s service implementation through SPI",
                                             EmbeddedControllerProvider.class.getName()));
    }

    return embeddedControllerProvider;
  }

}
