/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util.func;

import java.util.function.Predicate;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mule.runtime.core.api.util.func.CompositePredicate;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class CompositePredicateTestCase
extends AbstractMuleTestCase {
    private Predicate<String> predicate;

    @Test
    public void nullPredicates() {
        this.predicate = CompositePredicate.of(null);
        Assert.assertThat((Object)this.predicate.test(""), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void emptyPredicates() {
        this.predicate = CompositePredicate.of((Predicate[])new Predicate[0]);
        Assert.assertThat((Object)this.predicate.test(""), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void evaluateInOrder() {
        Predicate<String> predicate1 = this.createPredicate(true);
        Predicate<String> predicate2 = this.createPredicate(true);
        this.predicate = CompositePredicate.of((Predicate[])new Predicate[]{predicate1, predicate2});
        Assert.assertThat((Object)this.predicate.test(""), (Matcher)CoreMatchers.is((Object)true));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{predicate1, predicate2});
        ((Predicate)inOrder.verify(predicate1)).test("");
        ((Predicate)inOrder.verify(predicate2)).test("");
    }

    @Test
    public void failFast() {
        Predicate<String> predicate1 = this.createPredicate(false);
        Predicate<String> predicate2 = this.createPredicate(true);
        this.predicate = CompositePredicate.of((Predicate[])new Predicate[]{predicate1, predicate2});
        Assert.assertThat((Object)this.predicate.test(""), (Matcher)CoreMatchers.is((Object)false));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{predicate1, predicate2});
        ((Predicate)inOrder.verify(predicate1)).test("");
        ((Predicate)inOrder.verify(predicate2, Mockito.never())).test("");
    }

    private Predicate<String> createPredicate(boolean result) {
        Predicate predicate = (Predicate)Mockito.mock(Predicate.class);
        Mockito.when((Object)predicate.test((String)ArgumentMatchers.any())).thenReturn((Object)result);
        return predicate;
    }
}

