/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assume;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mule.runtime.core.api.util.WildcardAttributeEvaluator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
class WildcardAttributeEvaluatorTestCase
extends AbstractMuleTestCase {
    WildcardAttributeEvaluatorTestCase() {
    }

    @BeforeAll
    public static void checkJvmVersion() {
        Assume.assumeTrue((boolean)SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_20));
    }

    @Test
    void testStartsWithWildcard() {
        List<String> testValues = Arrays.asList("MULE", "MULEMAN", "EMULE", "MULE\\*", "\\*MULE");
        List<String> expectedValues = Arrays.asList("MULE", "MULEMAN", "MULE\\*");
        this.testScenario("MULE*", testValues, expectedValues);
    }

    @Test
    void testEndsWithWildcard() {
        List<String> testValues = Arrays.asList("MULE", "EMULE", "MAN-MULE-MAN", "\\*MULE", "MULE\\*");
        List<String> expectedValues = Arrays.asList("MULE", "EMULE", "\\*MULE");
        this.testScenario("*MULE", testValues, expectedValues);
    }

    @Test
    void testAllWildcard() {
        List<String> testValues = Arrays.asList("MULE", "EMULE", "MAN-MULE-MAN", "\\*MULE", "MULE\\*");
        List<String> expectedValues = Arrays.asList("MULE", "EMULE", "MAN-MULE-MAN", "\\*MULE", "MULE\\*");
        this.testScenario("*", testValues, expectedValues);
    }

    @Test
    void testWithEscapedCharactersOnly() {
        WildcardAttributeEvaluator wildcardAttributeEvaluator = new WildcardAttributeEvaluator("\\*");
        MatcherAssert.assertThat((Object)wildcardAttributeEvaluator.hasWildcards(), (Matcher)Is.is((Object)false));
    }

    @Test
    void testWithEscapedCharactersAndWildcards() {
        List<String> testValues = Arrays.asList("\\*MULE", "EMULE", "MAN-MULE-MAN", "", "MULE\\*", "\\*MULE\\*");
        List<String> expectedValues = Arrays.asList("\\*MULE", "\\*MULE\\*");
        this.testScenario("\\*MULE*", testValues, expectedValues);
    }

    @Test
    void testCallConstructorWithNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new WildcardAttributeEvaluator(null));
    }

    private void testScenario(String attributeValue, List<String> testValues, List<String> expectedValues) {
        WildcardAttributeEvaluator wildcardAttributeEvaluator = new WildcardAttributeEvaluator(attributeValue);
        MatcherAssert.assertThat((Object)wildcardAttributeEvaluator.hasWildcards(), (Matcher)Is.is((Object)true));
        final ArrayList resultingValues = new ArrayList();
        wildcardAttributeEvaluator.processValues(testValues, new WildcardAttributeEvaluator.MatchCallback(){

            public void processMatch(String matchedValue) {
                resultingValues.add(matchedValue);
            }
        });
        MatcherAssert.assertThat((Object)expectedValues.size(), (Matcher)Is.is((Object)resultingValues.size()));
        for (String expectedValue : expectedValues) {
            MatcherAssert.assertThat((Object)resultingValues.contains(expectedValue), (Matcher)Is.is((Object)true));
        }
    }
}

