/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util.xmlsecurity;

import io.qameta.allure.Issue;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.Validator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mule.runtime.core.api.util.xmlsecurity.XMLSecureFactories;

public class XMLSecureFactoriesPropertiesTestCase {
    private static final String SCHEMA_LOCATION = "http://www.w3.org/2001/XMLSchema";
    private org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories delegate;

    @Test
    @Issue(value="MULE-18814")
    public void decorateDefaultXmlSecureFactories() {
        try (MockedStatic utilities = Mockito.mockStatic(org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories.class);){
            this.delegate = (org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories)Mockito.spy(org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories.class);
            utilities.when(() -> XMLSecureFactories.createDefault()).thenReturn((Object)this.delegate);
            XMLSecureFactories deprecated = XMLSecureFactories.createDefault();
            this.assertDecoratedXMLSecureFactories(deprecated);
        }
    }

    @Test
    @Issue(value="MULE-18814")
    public void decorateCustomXmlSecureFactories() {
        try (MockedStatic utilities = Mockito.mockStatic(org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories.class);){
            this.delegate = (org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories)Mockito.spy(org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories.class);
            utilities.when(() -> XMLSecureFactories.createWithConfig((Boolean)ArgumentMatchers.anyBoolean(), (Boolean)ArgumentMatchers.anyBoolean())).thenReturn((Object)this.delegate);
            XMLSecureFactories deprecated = XMLSecureFactories.createWithConfig((Boolean)false, (Boolean)false);
            this.assertDecoratedXMLSecureFactories(deprecated);
        }
    }

    private void assertDecoratedXMLSecureFactories(XMLSecureFactories deprecated) {
        MatcherAssert.assertThat((Object)deprecated, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        deprecated.getDocumentBuilderFactory();
        ((org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories)Mockito.verify((Object)this.delegate)).getDocumentBuilderFactory();
        deprecated.getSAXParserFactory();
        ((org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories)Mockito.verify((Object)this.delegate)).getSAXParserFactory();
        deprecated.getXMLInputFactory();
        ((org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories)Mockito.verify((Object)this.delegate)).getXMLInputFactory();
        deprecated.getTransformerFactory();
        ((org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories)Mockito.verify((Object)this.delegate)).getTransformerFactory();
        deprecated.getSchemaFactory(SCHEMA_LOCATION);
        ((org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories)Mockito.verify((Object)this.delegate)).getSchemaFactory(SCHEMA_LOCATION);
        XMLInputFactory xmlInputFactory = (XMLInputFactory)Mockito.mock(XMLInputFactory.class);
        deprecated.configureXMLInputFactory(xmlInputFactory);
        ((org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories)Mockito.verify((Object)this.delegate)).configureXMLInputFactory(xmlInputFactory);
        TransformerFactory transformerFactory = (TransformerFactory)Mockito.mock(TransformerFactory.class);
        deprecated.configureTransformerFactory(transformerFactory);
        ((org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories)Mockito.verify((Object)this.delegate)).configureTransformerFactory(transformerFactory);
        Validator validator = (Validator)Mockito.mock(Validator.class);
        deprecated.configureValidator(validator);
        ((org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories)Mockito.verify((Object)this.delegate)).configureValidator(validator);
    }
}

