/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.internal.creation.bytebuddy.InlineByteBuddyMockMaker;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.mockito.plugins.ConfigurableMockitoPluginSwitch;
import org.mule.tck.size.SmallTest;

@SmallTest
public class IOUtilsTestCase
extends AbstractMuleTestCase {
    private static final List<String> POWER_MOCK_PLUGINS = Arrays.asList("mock-maker-inline", InlineByteBuddyMockMaker.class.getName());
    private static final String JAR_NAME = "stuff.jar";
    private static final String RESOURCE_NAME = "SomeFile.xml";
    @TempDir
    private File temporaryFolder;

    @BeforeAll
    public static void setupInlineMockMaker() {
        ConfigurableMockitoPluginSwitch.enablePlugins(POWER_MOCK_PLUGINS);
    }

    @AfterAll
    public static void restoreInlineMockMaker() {
        ConfigurableMockitoPluginSwitch.disablePlugins(POWER_MOCK_PLUGINS);
    }

    @Test
    @Issue(value="MULE-18264")
    @Description(value="The URLConnection used to read a resource inside a jar shouldn't have cache enabled")
    void cacheOnFalseWhenLoadResourceFromJar() throws Exception {
        File jarFile = this.createDummyJar();
        URLClassLoader classLoader = new URLClassLoader(new URL[]{jarFile.toURI().toURL()});
        URLConnection connection = this.mockURLConnection(classLoader.getResource(RESOURCE_NAME));
        MatcherAssert.assertThat((Object)connection, (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(JarURLConnection.class)));
        this.assertInputStream(connection);
        MatcherAssert.assertThat((Object)connection.getUseCaches(), (Matcher)CoreMatchers.is((Object)false));
        ((URLConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.atLeastOnce())).setUseCaches(false);
    }

    @Test
    @Issue(value="MULE-18264")
    @Description(value="The URLConnection used to read a resource located in filesystem should have cache enabled")
    void cacheOnTrueWhenLoadFromFilesystem() throws Exception {
        File resourceFile = new File(this.temporaryFolder, RESOURCE_NAME);
        resourceFile.createNewFile();
        URLConnection connection = this.mockURLConnection(resourceFile.toURI().toURL());
        this.assertInputStream(connection);
        ((URLConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).setUseCaches(false);
    }

    @Test
    void testLoadingResourcesAsStream() throws Exception {
        InputStream is = IOUtils.getResourceAsStream((String)"log4j2-test.xml", ((Object)((Object)this)).getClass(), (boolean)false, (boolean)false);
        Assert.assertNotNull((Object)is);
        is = IOUtils.getResourceAsStream((String)"does-not-exist.properties", ((Object)((Object)this)).getClass(), (boolean)false, (boolean)false);
        Assert.assertNull((Object)is);
    }

    @Test
    void bufferSize() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[8192]);
        OutputStream out = (OutputStream)Mockito.mock(OutputStream.class);
        IOUtils.copyLarge((InputStream)in, (OutputStream)out);
        ((OutputStream)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)2))).write((byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
    }

    @Test
    void increaseBufferSizeViaSystemProperty() throws Exception {
        int newBufferSize = 8192;
        MuleTestUtils.testWithSystemProperty((String)"mule.streaming.bufferSize", (Object)Integer.toString(8192), () -> {
            ByteArrayInputStream in = new ByteArrayInputStream(new byte[8192]);
            OutputStream out = (OutputStream)Mockito.mock(OutputStream.class);
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            String classPath = System.getProperty("java.class.path");
            String modulePath = System.getProperty("jdk.module.path");
            List classPathEntries = (modulePath != null ? Stream.concat(Stream.of(classPath.split(File.pathSeparator)), Stream.of(modulePath.split(File.pathSeparator))) : Stream.of(classPath.split(File.pathSeparator))).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            URLClassLoader newClassLoader = new URLClassLoader((URL[])classPathEntries.stream().map(path -> {
                try {
                    return Paths.get(path, new String[0]).toUri().toURL();
                }
                catch (MalformedURLException e) {
                    Assert.fail((String)e.getMessage());
                    return null;
                }
            }).toArray(URL[]::new), null);
            Class<?> clazz = Class.forName(IOUtils.class.getCanonicalName(), true, newClassLoader);
            try {
                Thread.currentThread().setContextClassLoader(newClassLoader);
                clazz.getMethod("copyLarge", InputStream.class, OutputStream.class).invoke(clazz, in, out);
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
            ((OutputStream)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)1))).write((byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        });
    }

    @Test
    void convertsToStringWithEncoding() throws Exception {
        Charset encoding = Charset.forName("EUC-JP");
        String encodedText = "\u3053";
        ByteArrayInputStream in = new ByteArrayInputStream("\u3053".getBytes(encoding));
        String converted = IOUtils.toString((InputStream)in, (Charset)encoding);
        MatcherAssert.assertThat((Object)converted, (Matcher)Matchers.equalTo((Object)"\u3053"));
    }

    private URLConnection mockURLConnection(URL url) throws Exception {
        try (MockedStatic utilities = Mockito.mockStatic(org.mule.runtime.core.internal.util.IOUtils.class);){
            AtomicReference connection = new AtomicReference();
            URL mockedURL = (URL)Mockito.spy((Object)url);
            utilities.when(() -> IOUtils.getResourceAsStream((String)ArgumentMatchers.anyString(), (Class)((Class)ArgumentMatchers.any(Class.class)))).then(InvocationOnMock::callRealMethod);
            utilities.when(() -> IOUtils.getResourceAsStream((String)ArgumentMatchers.anyString(), (Class)((Class)ArgumentMatchers.any(Class.class)), (boolean)ArgumentMatchers.anyBoolean(), (boolean)ArgumentMatchers.anyBoolean())).then(InvocationOnMock::callRealMethod);
            utilities.when(() -> IOUtils.getResourceAsUrl((String)ArgumentMatchers.anyString(), (Class)((Class)ArgumentMatchers.any(Class.class)), (boolean)ArgumentMatchers.anyBoolean(), (boolean)ArgumentMatchers.anyBoolean())).then(invocationOnMock -> mockedURL);
            Mockito.when((Object)mockedURL.openConnection()).thenAnswer(a -> {
                URLConnection conn = (URLConnection)Mockito.spy((Object)((URLConnection)a.callRealMethod()));
                connection.set(conn);
                return conn;
            });
            IOUtils.getResourceAsStream((String)RESOURCE_NAME, ((Object)((Object)this)).getClass());
            URLConnection uRLConnection = (URLConnection)connection.get();
            return uRLConnection;
        }
    }

    private void assertInputStream(URLConnection connection) throws Exception {
        try (InputStream is = connection.getInputStream();){
            Assert.assertNotNull((Object)is);
        }
    }

    private File createDummyJar() throws IOException {
        File jarFile = new File(this.temporaryFolder, JAR_NAME);
        try (JarOutputStream jar = new JarOutputStream(new FileOutputStream(jarFile));){
            jar.putNextEntry(new JarEntry(RESOURCE_NAME));
        }
        return jarFile;
    }
}

