/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.core.api.util;

import static org.apache.commons.lang3.ArrayUtils.EMPTY_STRING_ARRAY;

import java.util.ArrayList;
import java.util.HexFormat;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang3.CharUtils;

/**
 * <code>StringUtils</code> contains useful methods for manipulating Strings. /*
 *
 * @deprecated Use {@link org.apache.commons.lang3.StringUtils} instead
 */
@Deprecated(since = "4.11", forRemoval = true)
// @ThreadSafe
public class StringUtils {

  public static final String WHITE_SPACE = " ";
  public static final String DASH = "-";
  /*
   * @deprecated Use {@link org.apache.commons.lang3.StringUtils#EMPTY} instead
   */
  @Deprecated(since = "4.10", forRemoval = true)
  public static final String EMPTY = "";

  // lookup tables needed for toHexString(byte[], boolean)
  private static final String HEX_CHARACTERS = "0123456789abcdef";
  private static final String HEX_CHARACTERS_UC = HEX_CHARACTERS.toUpperCase();

  /**
   * Like {@link org.apache.commons.lang3.StringUtils#split(String, String)}, but additionally trims whitespace from the result
   * tokens.
   *
   * @deprecated Use {@link org.apache.commons.lang3.StringUtils#split(String, String)} instead
   */
  @Deprecated(since = "4.10", forRemoval = true)
  public static String[] splitAndTrim(String string, String delim) {
    if (string == null) {
      return null;
    }

    if (StringUtils.isEmpty(string)) {
      return EMPTY_STRING_ARRAY;
    }

    String[] rawTokens = org.apache.commons.lang3.StringUtils.split(string, delim);
    List<String> tokens = new ArrayList<>();
    if (rawTokens != null) {
      for (String rawToken : rawTokens) {
        String token = StringUtils.trim(rawToken);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(token)) {
          tokens.add(token);
        }
      }
    }

    return tokens.stream().toArray(s -> new String[s]);
  }

  /**
   * Convert a hexadecimal string into its byte representation.
   *
   * @param hex The hexadecimal string.
   * @return The converted bytes or <code>null</code> if the hex String is null.
   */
  public static byte[] hexStringToByteArray(String hex) {
    if (hex == null) {
      return null;
    }

    int stringLength = hex.length();
    if (stringLength % 2 != 0) {
      throw new IllegalArgumentException("Hex String must have even number of characters!");
    }

    byte[] result = new byte[stringLength / 2];

    int j = 0;
    for (int i = 0; i < result.length; i++) {
      char hi = Character.toLowerCase(hex.charAt(j++));
      char lo = Character.toLowerCase(hex.charAt(j++));
      result[i] = (byte) ((Character.digit(hi, 16) << 4) | Character.digit(lo, 16));
    }

    return result;
  }

  /**
   * Like {@link org.apache.commons.lang3.StringUtils#repeat(String, int)} but with a single character as argument.
   *
   * @deprecated Use {@link org.apache.commons.lang3.StringUtils#repeat(String, int)} instead
   */
  @Deprecated(since = "4.10", forRemoval = true)
  public static String repeat(char c, int len) {
    return org.apache.commons.lang3.StringUtils.repeat(CharUtils.toString(c), len);
  }

  /**
   * @see #toHexString(byte[])
   * @deprecated Use {@link HexFormat} instead
   */
  @Deprecated(forRemoval = true, since = "4.10")
  public static String toHexString(byte[] bytes) {
    return StringUtils.toHexString(bytes, false);
  }

  /**
   * Convert a byte array to a hexadecimal string.
   *
   * @param bytes     The bytes to format.
   * @param uppercase When <code>true</code> creates uppercase hex characters instead of lowercase (the default).
   * @return A hexadecimal representation of the specified bytes.
   * @deprecated Use {@link HexFormat} instead
   */
  @Deprecated(forRemoval = true, since = "4.10")
  public static String toHexString(byte[] bytes, boolean uppercase) {
    if (bytes == null) {
      return null;
    }

    int numBytes = bytes.length;
    StringBuilder str = new StringBuilder(numBytes * 2);

    String table = (uppercase ? HEX_CHARACTERS_UC : HEX_CHARACTERS);

    for (int i = 0; i < numBytes; i++) {
      str.append(table.charAt(bytes[i] >>> 4 & 0x0f));
      str.append(table.charAt(bytes[i] & 0x0f));
    }

    return str.toString();
  }

  /**
   * Matches the given value to the given pattern. Then returns the group at matchIndex.
   *
   * @param pattern    the pattern to use as regexp
   * @param value      the value to evaluate
   * @param matchIndex the group index to be returned
   * @return the value of the group at the given index. <code>null</code> if no match found
   * @throws IllegalArgumentException if pattern or value are null.
   */
  public static String match(Pattern pattern, String value, int matchIndex) throws IllegalArgumentException {
    if (value == null || pattern == null) {
      throw new IllegalArgumentException("pattern and value cannot be null");
    }
    Matcher matcher = pattern.matcher(value);
    if (matcher.find() && (matcher.groupCount() >= matchIndex)) {
      return matcher.group(matchIndex);
    }

    return null;
  }

  /**
   * If {@code value} is not {@link #isBlank(String)}, then it feeds the value into the {@code consumer}
   *
   * @param value    a value
   * @param consumer a String {@link Consumer}
   */
  public static void ifNotBlank(String value, Consumer<String> consumer) {
    if (!isBlank(value)) {
      consumer.accept(value);
    }
  }

  /*
   * @deprecated Use {@link org.apache.commons.lang3.StringUtils#isEmpty(String)} instead
   */
  @Deprecated(since = "4.10", forRemoval = true)
  public static boolean isEmpty(String str) {
    return org.apache.commons.lang3.StringUtils.isEmpty(str);
  }

  /*
   * @deprecated Use {@link org.apache.commons.lang3.StringUtils#isBlank(String)} instead
   */
  @Deprecated(since = "4.10", forRemoval = true)
  public static boolean isBlank(String str) {
    return org.apache.commons.lang3.StringUtils.isBlank(str);
  }

  /*
   * @deprecated Use {@link org.apache.commons.lang3.StringUtils#trim(String)} instead
   */
  @Deprecated(since = "4.10", forRemoval = true)
  public static String trim(String str) {
    return org.apache.commons.lang3.StringUtils.trim(str);
  }

  /**
   * Remove trailing slash from {@code url}
   *
   * @param url an url
   *
   * @since 4.3.0
   */
  public static String sanitizeUrl(String url) {
    if (url.endsWith("/")) {
      url = url.substring(0, url.length() - 1);
    }
    return url;
  }

  private StringUtils() {}
}
