/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.core.api.util;

import static org.apache.commons.lang3.JavaVersion.JAVA_21;
import static org.apache.commons.lang3.SystemUtils.isJavaVersionAtLeast;

import java.util.Collection;

@Deprecated(since = "4.10", forRemoval = true)
public final class WildcardAttributeEvaluator {

  static {
    if (isJavaVersionAtLeast(JAVA_21)) {
      throw new UnsupportedOperationException("This is deprecated since 4.10, enforced if running with Java 21+.");
    }
  }

  private final String escapedValue;
  private final Boolean hasWildcards;

  public WildcardAttributeEvaluator(String attributeValue) {
    if (attributeValue == null) {
      throw new IllegalArgumentException("null not allowed");
    }
    this.escapedValue = attributeValue.replaceAll("\\*", "*");
    hasWildcards = attributeValue.startsWith("*") || (attributeValue.endsWith("*") && !attributeValue.endsWith("\\*"))
        || attributeValue.equals("*");
  }

  public boolean hasWildcards() {
    return hasWildcards;
  }

  public void processValues(Collection<String> values, MatchCallback matchCallback) {
    if (!hasWildcards()) {
      throw new IllegalStateException("Can't call processValues with non wildcard attribute");
    }
    for (String value : values) {
      if (matches(value)) {
        matchCallback.processMatch(value);
      }
    }
  }

  public boolean matches(String value) {
    if (value == null) {
      return false;
    }
    if (escapedValue.equals("*")) {
      return true;
    } else if (escapedValue.startsWith("*")) {
      return value.endsWith(escapedValue.substring(1, escapedValue.length()));
    } else if (escapedValue.endsWith("*")) {
      return value.startsWith(escapedValue.substring(0, escapedValue.length() - 1));
    }
    return false;
  }

  public interface MatchCallback {

    public void processMatch(String matchedValue);
  }
}
