/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.connectivity.internal.platform.schema;

import java.util.LinkedHashSet;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.connectivity.internal.platform.schema.SemanticTermsHelper;

public class SemanticTermsHelperTestCase {
    @Test
    public void getConnectionTermsFromNullSet() {
        Assert.assertThat((Object)SemanticTermsHelper.getConnectionTerms(null), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void getConnectionTerms() {
        LinkedHashSet<String> inputTerms = new LinkedHashSet<String>();
        inputTerms.add("connectivity.ApiKeyAuthenticationConnection");
        inputTerms.add("connectivity.OAuthAuthorizationCodeConnection");
        inputTerms.add("apiContract.endPoint");
        Set resolvedTerms = SemanticTermsHelper.getConnectionTerms(inputTerms);
        Assert.assertThat((Object)resolvedTerms, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)resolvedTerms, (Matcher)Matchers.contains((Object[])new String[]{"connectivity.ApiKeyAuthenticationConnection", "connectivity.OAuthAuthorizationCodeConnection"}));
    }

    @Test
    public void getParameterTermsFromNullSet() {
        Assert.assertThat((Object)SemanticTermsHelper.getParameterTerms(null), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void getParameterTerms() {
        LinkedHashSet<String> inputTerms = new LinkedHashSet<String>();
        inputTerms.add("connectivity.domain");
        inputTerms.add("apiContract.endPoint");
        inputTerms.add("peperoni");
        Set resolvedTerms = SemanticTermsHelper.getParameterTerms(inputTerms);
        Assert.assertThat((Object)resolvedTerms, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)resolvedTerms, (Matcher)Matchers.contains((Object[])new String[]{"connectivity.domain", "apiContract.endPoint"}));
    }
}

