/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.connectivity.internal.platform.schema;

import org.mule.runtime.connectivity.api.platform.schema.ConnectivitySchemaBody;
import org.mule.runtime.connectivity.api.platform.schema.ConnectivitySchemaRoot;

import java.util.Objects;

/**
 * Default implementation of {@link ConnectivitySchemaBody}
 *
 * @since 1.0
 */
public class DefaultConnectivitySchemaBody implements ConnectivitySchemaBody {

  private ConnectivitySchemaRoot root = new DefaultConnectivitySchemaRoot();

  /**
   * {@inheritDoc}
   */
  @Override
  public ConnectivitySchemaRoot getRoot() {
    return root;
  }

  @Override
  public boolean equals(Object o) {
    if (o instanceof ConnectivitySchemaBody) {
      ConnectivitySchemaBody that = (ConnectivitySchemaBody) o;
      return Objects.equals(root, that.getRoot());
    }

    return false;
  }

  @Override
  public int hashCode() {
    return Objects.hash(root);
  }
}
