/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.connectivity.api.platform.schema.generator;

import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.connectivity.api.platform.schema.ConnectivitySchema;
import org.mule.runtime.connectivity.api.platform.schema.ExchangeAssetDescriptor;

import java.util.List;

/**
 * Generates {@link ConnectivitySchema} instances based on the {@link ConnectionProviderModel connection providers} defined in an
 * {@link ExtensionModel}
 *
 * @since 1.0
 */
@NoImplement
public interface ConnectivitySchemaGenerator {

  /**
   * Generates one {@link ConnectivitySchema} per each unique {@link ConnectionProviderModel} defined in the
   * {@code extensionModel}
   *
   * @param extensionModel  a {@link ExtensionModel}
   * @param assetDescriptor an {@link ExchangeAssetDescriptor} with the modeled extension asset information
   * @return a {@link List} of {@link ConnectivitySchema} instances
   */
  List<ConnectivitySchema> generateSchemas(ExtensionModel extensionModel, ExchangeAssetDescriptor assetDescriptor);
}
