/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.cfg.internal.queries;

import static org.mule.runtime.cfg.AllureCfgConstants.CFG_FEATURE;
import static org.mule.runtime.cfg.AllureCfgConstants.Cfg.QUERIES;
import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.mule.runtime.cfg.utils.CfgTestUtils.hasIdentifier;
import static org.mule.runtime.cfg.utils.CfgTestUtils.NOOP;
import static org.mule.runtime.cfg.utils.CfgTestUtils.PARALLEL_FOREACH;
import static org.mule.runtime.cfg.utils.CfgTestUtils.SCATTER_GATHER;
import static org.mule.runtime.cfg.utils.CfgTestUtils.SET_VARIABLE;
import static org.mule.runtime.cfg.utils.CfgTestUtils.testTree;

import org.mule.runtime.cfg.api.ChainExecutionPathTree;

import org.junit.Before;
import org.junit.Test;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;

@Feature(CFG_FEATURE)
@Story(QUERIES)
public class SimpleTreeQueriesTestCase {

  private ChainExecutionPathTree tree;

  @Before
  public void setup() {
    tree = testTree();
  }


  @Test
  public void elementNotPresent() {
    assertThat(tree.anyExecutionPathContains(tree -> hasIdentifier(tree, PARALLEL_FOREACH)), is(false));
    assertThat(tree.allExecutionPathsContain(tree -> hasIdentifier(tree, PARALLEL_FOREACH)), is(false));
    assertThat(tree.noneExecutionPathsContains(tree -> hasIdentifier(tree, PARALLEL_FOREACH)), is(true));
  }

  @Test
  public void elementIsInOneRoute() {
    assertThat(tree.anyExecutionPathContains(tree -> hasIdentifier(tree, SET_VARIABLE)), is(true));
    assertThat(tree.allExecutionPathsContain(tree -> hasIdentifier(tree, SET_VARIABLE)), is(false));
    assertThat(tree.noneExecutionPathsContains(tree -> hasIdentifier(tree, SET_VARIABLE)), is(false));
  }

  @Test
  public void elementIsNotInAllRoutes() {
    assertThat(tree.anyExecutionPathContains(tree -> hasIdentifier(tree, SCATTER_GATHER)), is(true));
    // The for each might not be executed at all
    assertThat(tree.allExecutionPathsContain(tree -> hasIdentifier(tree, SCATTER_GATHER)), is(false));
    assertThat(tree.noneExecutionPathsContains(tree -> hasIdentifier(tree, SCATTER_GATHER)), is(false));
  }

  @Test
  public void elementIsInAllRoutes() {
    assertThat(tree.anyExecutionPathContains(tree -> hasIdentifier(tree, NOOP)), is(true));
    assertThat(tree.allExecutionPathsContain(tree -> hasIdentifier(tree, NOOP)), is(true));
    assertThat(tree.noneExecutionPathsContains(tree -> hasIdentifier(tree, NOOP)), is(false));
  }

}
