/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.cfg.internal.node;

import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeVisitor;

import java.util.function.Predicate;


public class SourceNode implements ChainExecutionPathTree {

  private final ComponentAst componentAst;

  public SourceNode(ComponentAst componentAst) {
    this.componentAst = componentAst;
  }

  @Override
  public void accept(ChainExecutionPathTreeVisitor visitor) {
    visitor.visitSource(this);
  }

  @Override
  public ComponentAst getComponentAst() {
    return componentAst;
  }

  @Override
  public boolean anyExecutionPathContains(Predicate<ChainExecutionPathTree> predicate) {
    return predicate.test(this);
  }

  @Override
  public boolean allExecutionPathsContain(Predicate<ChainExecutionPathTree> predicate) {
    return predicate.test(this);
  }

}
