/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.cfg.visitors;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.hamcrest.collection.IsMapWithSize;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.runtime.cfg.api.BaseChainExecutionPathTreeVisitor;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeVisitor;
import org.mule.runtime.cfg.internal.node.NullNode;
import org.mule.runtime.cfg.utils.CfgTestUtils;
import org.mule.runtime.cfg.utils.TestCfg;
import org.mule.runtime.cfg.visitors.CountingVisitor;

@Feature(value="Control Flow Graph")
@Story(value="Traversal of CFG Tree using visitor")
public class SimpleVisitingTestCase {
    @Test
    public void countOnSimpleApplication() {
        ChainExecutionPathTree tree = CfgTestUtils.testTree();
        CountingVisitor visitor = new CountingVisitor();
        tree.accept((ChainExecutionPathTreeVisitor)visitor);
        MatcherAssert.assertThat((Object)visitor.sourceCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.operationCount, (Matcher)CoreMatchers.is((Object)9));
        MatcherAssert.assertThat((Object)visitor.scopeCount, (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)visitor.routerCount, (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)visitor.errorHandlerCount, (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void countOnApplicationWithErrorHandling() {
        ChainExecutionPathTree tree = CfgTestUtils.testTreeWithErrorHandling(true);
        CountingVisitor visitor = new CountingVisitor();
        tree.accept((ChainExecutionPathTreeVisitor)visitor);
        MatcherAssert.assertThat((Object)visitor.sourceCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.operationCount, (Matcher)CoreMatchers.is((Object)11));
        MatcherAssert.assertThat((Object)visitor.scopeCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.routerCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.errorHandlerCount, (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat(visitor.potentialErrorInvocations.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"name/1/3/0", "name/1/3/1", "name/2/1"}));
        MatcherAssert.assertThat((Object)visitor.potentialErrorInvocations.get("name/1/3/0"), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.potentialErrorInvocations.get("name/1/3/1"), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.potentialErrorInvocations.get("name/2/1"), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void countOnApplicationWithErrorHandlingWithNoMatchingTypes() {
        ChainExecutionPathTree tree = CfgTestUtils.testTreeWithErrorHandling(false);
        CountingVisitor visitor = new CountingVisitor();
        tree.accept((ChainExecutionPathTreeVisitor)visitor);
        MatcherAssert.assertThat((Object)visitor.sourceCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.operationCount, (Matcher)CoreMatchers.is((Object)11));
        MatcherAssert.assertThat((Object)visitor.scopeCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.routerCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.errorHandlerCount, (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat(visitor.potentialErrorInvocations.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"name/1/3/0", "name/1/3/1", "name/2/1"}));
        MatcherAssert.assertThat((Object)visitor.potentialErrorInvocations.get("name/1/3/0"), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.potentialErrorInvocations.get("name/1/3/1"), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.potentialErrorInvocations.get("name/2/1"), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void countOnApplicationWithRaiseErrorAtFlowLevelNoErrorHandler() {
        String flowName = "raiseErrorAtFlowLevelNoErrorHandler";
        ChainExecutionPathTree tree = CfgTestUtils.TEST_TREE_WITH_RAISE_ERROR.getCfgForFlow(flowName);
        CountingVisitor visitor = new CountingVisitor();
        tree.accept((ChainExecutionPathTreeVisitor)visitor);
        MatcherAssert.assertThat((Object)visitor.sourceCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.operationCount, (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)visitor.scopeCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.routerCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.errorHandlerCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat(visitor.potentialErrorInvocations, (Matcher)CoreMatchers.is((Matcher)IsMapWithSize.anEmptyMap()));
        MatcherAssert.assertThat(visitor.interruptedChains, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{flowName}));
    }

    @Test
    public void countOnApplicationWithRaiseErrorAtFlowLevelWithErrorHandler() {
        String flowName = "raiseErrorAtFlowLevelWithErrorHandler";
        ChainExecutionPathTree tree = CfgTestUtils.TEST_TREE_WITH_RAISE_ERROR.getCfgForFlow(flowName);
        CountingVisitor visitor = new CountingVisitor();
        tree.accept((ChainExecutionPathTreeVisitor)visitor);
        MatcherAssert.assertThat((Object)visitor.sourceCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.operationCount, (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)visitor.scopeCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.routerCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.errorHandlerCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(visitor.potentialErrorInvocations.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{flowName + "/3/0"}));
        MatcherAssert.assertThat((Object)visitor.potentialErrorInvocations.get(flowName + "/3/0"), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(visitor.interruptedChains, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{flowName}));
    }

    @Test
    public void countOnApplicationWithRaiseErrorAtTryWithMatchingAllOnErrorContinue() {
        String flowName = "raiseErrorAtTryWithMatchingAllOnErrorContinue";
        ChainExecutionPathTree tree = CfgTestUtils.TEST_TREE_WITH_RAISE_ERROR.getCfgForFlow(flowName);
        CountingVisitor visitor = new CountingVisitor();
        tree.accept((ChainExecutionPathTreeVisitor)visitor);
        MatcherAssert.assertThat((Object)visitor.sourceCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.operationCount, (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)visitor.scopeCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.routerCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.errorHandlerCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(visitor.potentialErrorInvocations.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{flowName + "/1/2/0"}));
        MatcherAssert.assertThat((Object)visitor.potentialErrorInvocations.get(flowName + "/1/2/0"), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(visitor.interruptedChains, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{flowName + "/1"}));
    }

    @Test
    public void countOnApplicationWithRaiseErrorAtTryWithMatchingOnErrorContinue() {
        String flowName = "raiseErrorAtTryWithMatchingOnErrorContinue";
        ChainExecutionPathTree tree = CfgTestUtils.TEST_TREE_WITH_RAISE_ERROR.getCfgForFlow(flowName);
        CountingVisitor visitor = new CountingVisitor();
        tree.accept((ChainExecutionPathTreeVisitor)visitor);
        MatcherAssert.assertThat((Object)visitor.sourceCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.operationCount, (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)visitor.scopeCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.routerCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.errorHandlerCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(visitor.potentialErrorInvocations.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{flowName + "/1/2/0"}));
        MatcherAssert.assertThat((Object)visitor.potentialErrorInvocations.get(flowName + "/1/2/0"), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(visitor.interruptedChains, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{flowName + "/1"}));
    }

    @Test
    public void countOnApplicationWithRaiseErrorAtTryWithMatchingOnErrorContinueWithRaiseError() {
        String flowName = "raiseErrorAtTryWithMatchingOnErrorContinueWithRaiseError";
        ChainExecutionPathTree tree = CfgTestUtils.TEST_TREE_WITH_RAISE_ERROR.getCfgForFlow(flowName);
        CountingVisitor visitor = new CountingVisitor();
        tree.accept((ChainExecutionPathTreeVisitor)visitor);
        MatcherAssert.assertThat((Object)visitor.sourceCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.operationCount, (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)visitor.scopeCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.routerCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.errorHandlerCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(visitor.potentialErrorInvocations.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{flowName + "/1/2/0"}));
        MatcherAssert.assertThat((Object)visitor.potentialErrorInvocations.get(flowName + "/1/2/0"), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(visitor.interruptedChains, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{flowName + "/1", flowName + "/1/2/0", flowName}));
    }

    @Test
    public void countOnApplicationWithRaiseErrorAtTryWithMatchingOnErrorContinueWithRaiseErrorThenAnotherContinue() {
        String flowName = "raiseErrorAtTryWithMatchingOnErrorContinueWithRaiseErrorThenAnotherContinue";
        ChainExecutionPathTree tree = CfgTestUtils.TEST_TREE_WITH_RAISE_ERROR.getCfgForFlow(flowName);
        CountingVisitor visitor = new CountingVisitor();
        tree.accept((ChainExecutionPathTreeVisitor)visitor);
        MatcherAssert.assertThat((Object)visitor.sourceCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.operationCount, (Matcher)CoreMatchers.is((Object)6));
        MatcherAssert.assertThat((Object)visitor.scopeCount, (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)visitor.routerCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.errorHandlerCount, (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(visitor.potentialErrorInvocations.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{flowName + "/1/0/2/0", flowName + "/1/1/0"}));
        MatcherAssert.assertThat((Object)visitor.potentialErrorInvocations.get(flowName + "/1/0/2/0"), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.potentialErrorInvocations.get(flowName + "/1/1/0"), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(visitor.interruptedChains, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{flowName + "/1/0", flowName + "/1/0/2/0", flowName + "/1"}));
    }

    @Test
    public void countOnApplicationWithRaiseErrorAtTryWithNotMatchingOnErrorContinue() {
        String flowName = "raiseErrorAtTryWithNotMatchingOnErrorContinue";
        ChainExecutionPathTree tree = CfgTestUtils.TEST_TREE_WITH_RAISE_ERROR.getCfgForFlow(flowName);
        CountingVisitor visitor = new CountingVisitor();
        tree.accept((ChainExecutionPathTreeVisitor)visitor);
        MatcherAssert.assertThat((Object)visitor.sourceCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.operationCount, (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)visitor.scopeCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.routerCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.errorHandlerCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(visitor.potentialErrorInvocations, (Matcher)CoreMatchers.is((Matcher)IsMapWithSize.anEmptyMap()));
        MatcherAssert.assertThat(visitor.interruptedChains, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{flowName + "/1", flowName}));
    }

    @Test
    public void countOnApplicationWithRaiseErrorAtTryWithMatchingOnErrorPropagate() {
        String flowName = "raiseErrorAtTryWithMatchingOnErrorPropagate";
        ChainExecutionPathTree tree = CfgTestUtils.TEST_TREE_WITH_RAISE_ERROR.getCfgForFlow(flowName);
        CountingVisitor visitor = new CountingVisitor();
        tree.accept((ChainExecutionPathTreeVisitor)visitor);
        MatcherAssert.assertThat((Object)visitor.sourceCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.operationCount, (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)visitor.scopeCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.routerCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.errorHandlerCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(visitor.potentialErrorInvocations.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{flowName + "/1/2/0"}));
        MatcherAssert.assertThat((Object)visitor.potentialErrorInvocations.get(flowName + "/1/2/0"), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(visitor.interruptedChains, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{flowName + "/1", flowName}));
    }

    @Test
    @Ignore(value="W-17130449: Choice is a special case because all routes are ONCE_OR_NONE but in the presence of otherwise, one will execute")
    public void countOnApplicationWithRaiseErrorAtChoiceAllRoutes() {
        String flowName = "raiseErrorAtChoiceAllRoutes";
        ChainExecutionPathTree tree = CfgTestUtils.TEST_TREE_WITH_RAISE_ERROR.getCfgForFlow(flowName);
        CountingVisitor visitor = new CountingVisitor();
        tree.accept((ChainExecutionPathTreeVisitor)visitor);
        MatcherAssert.assertThat((Object)visitor.sourceCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.operationCount, (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)visitor.scopeCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.routerCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.errorHandlerCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat(visitor.potentialErrorInvocations, (Matcher)CoreMatchers.is((Matcher)IsMapWithSize.anEmptyMap()));
        MatcherAssert.assertThat(visitor.interruptedChains, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{flowName + "/1/0", flowName + "/1/1"}));
    }

    @Test
    public void countOnApplicationWithRaiseErrorAtChoiceSomeRoutes() {
        String flowName = "raiseErrorAtChoiceSomeRoutes";
        ChainExecutionPathTree tree = CfgTestUtils.TEST_TREE_WITH_RAISE_ERROR.getCfgForFlow(flowName);
        CountingVisitor visitor = new CountingVisitor();
        tree.accept((ChainExecutionPathTreeVisitor)visitor);
        MatcherAssert.assertThat((Object)visitor.sourceCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.operationCount, (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)visitor.scopeCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.routerCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.errorHandlerCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat(visitor.potentialErrorInvocations, (Matcher)CoreMatchers.is((Matcher)IsMapWithSize.anEmptyMap()));
        MatcherAssert.assertThat(visitor.interruptedChains, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{flowName + "/1/0"}));
    }

    @Test
    public void countOnApplicationWithRaiseErrorAtScatterGatherAllRoutes() {
        String flowName = "raiseErrorAtScatterGatherAllRoutes";
        ChainExecutionPathTree tree = CfgTestUtils.TEST_TREE_WITH_RAISE_ERROR.getCfgForFlow(flowName);
        CountingVisitor visitor = new CountingVisitor();
        tree.accept((ChainExecutionPathTreeVisitor)visitor);
        MatcherAssert.assertThat((Object)visitor.sourceCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.operationCount, (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)visitor.scopeCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.routerCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.errorHandlerCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat(visitor.potentialErrorInvocations, (Matcher)CoreMatchers.is((Matcher)IsMapWithSize.anEmptyMap()));
        MatcherAssert.assertThat(visitor.interruptedChains, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{flowName + "/1/0", flowName + "/1/1", flowName}));
    }

    @Test
    public void countOnApplicationWithRaiseErrorAtReferencedFlowWithNoErrorHandling() {
        String flowName = "raiseErrorAtReferencedFlowWithNoErrorHandling";
        String referencedFlowName = "raiseErrorAtFlowLevelNoErrorHandler";
        ChainExecutionPathTree tree = CfgTestUtils.TEST_TREE_WITH_RAISE_ERROR.getCfgForFlow(flowName);
        CountingVisitor visitor = new CountingVisitor();
        tree.accept((ChainExecutionPathTreeVisitor)visitor);
        MatcherAssert.assertThat((Object)visitor.sourceCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.operationCount, (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)visitor.scopeCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.routerCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.errorHandlerCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat(visitor.potentialErrorInvocations, (Matcher)CoreMatchers.is((Matcher)IsMapWithSize.anEmptyMap()));
        MatcherAssert.assertThat(visitor.interruptedChains, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{referencedFlowName, flowName}));
    }

    @Test
    public void countOnApplicationWithRaiseErrorAtReferencedFlowWithErrorHandling() {
        String flowName = "raiseErrorAtReferencedFlowWithErrorHandling";
        String referencedFlowName = "raiseErrorAtFlowLevelWithErrorHandler";
        ChainExecutionPathTree tree = CfgTestUtils.TEST_TREE_WITH_RAISE_ERROR.getCfgForFlow(flowName);
        CountingVisitor visitor = new CountingVisitor();
        tree.accept((ChainExecutionPathTreeVisitor)visitor);
        MatcherAssert.assertThat((Object)visitor.sourceCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.operationCount, (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)visitor.scopeCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.routerCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.errorHandlerCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(visitor.potentialErrorInvocations.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{referencedFlowName + "/3/0"}));
        MatcherAssert.assertThat((Object)visitor.potentialErrorInvocations.get(referencedFlowName + "/3/0"), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(visitor.interruptedChains, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{referencedFlowName}));
    }

    @Test
    public void countOnApplicationWithRaiseErrorAtRecursiveFlow() {
        ChainExecutionPathTree tree = CfgTestUtils.TEST_TREE_WITH_RAISE_ERROR.getCfgForFlow("raiseErrorAtRecursiveFlow");
        CountingVisitor visitor = new CountingVisitor();
        tree.accept((ChainExecutionPathTreeVisitor)visitor);
        MatcherAssert.assertThat((Object)visitor.sourceCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.operationCount, (Matcher)CoreMatchers.is((Object)6));
        MatcherAssert.assertThat((Object)visitor.scopeCount, (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)visitor.routerCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.errorHandlerCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat(visitor.potentialErrorInvocations, (Matcher)CoreMatchers.is((Matcher)IsMapWithSize.anEmptyMap()));
    }

    @Test
    @Description(value="Checks that empty routes are not null when visited and have an associated ComponentAst")
    public void emptyRoutes() {
        TestCfg cfg = CfgTestUtils.testTreeWithEmptyRoutes();
        ChainExecutionPathTree flowTree = cfg.getCfgForFlow("flowWithEmptyRoutes");
        final AtomicInteger routeStarts = new AtomicInteger();
        final AtomicInteger routeFinishes = new AtomicInteger();
        flowTree.accept((ChainExecutionPathTreeVisitor)new BaseChainExecutionPathTreeVisitor(){

            public boolean innerRouteStarted(ChainExecutionPathTree innerChain) {
                MatcherAssert.assertThat((Object)innerChain, (Matcher)IsNot.not((Matcher)IsInstanceOf.instanceOf(NullNode.class)));
                MatcherAssert.assertThat((Object)innerChain.children(), (Matcher)CoreMatchers.is((Matcher)IsEmptyCollection.empty()));
                MatcherAssert.assertThat((Object)innerChain.getComponentAst(), (Matcher)CoreMatchers.is((Matcher)IsNot.not((Matcher)IsNull.nullValue())));
                routeStarts.incrementAndGet();
                return super.innerRouteStarted(innerChain);
            }

            public void innerRouteFinished(ChainExecutionPathTree innerChain) {
                MatcherAssert.assertThat((Object)innerChain, (Matcher)IsNot.not((Matcher)IsInstanceOf.instanceOf(NullNode.class)));
                MatcherAssert.assertThat((Object)innerChain.children(), (Matcher)CoreMatchers.is((Matcher)IsEmptyCollection.empty()));
                MatcherAssert.assertThat((Object)innerChain.getComponentAst(), (Matcher)CoreMatchers.is((Matcher)IsNot.not((Matcher)IsNull.nullValue())));
                routeFinishes.incrementAndGet();
                super.innerRouteFinished(innerChain);
            }
        });
        MatcherAssert.assertThat((Object)routeStarts.get(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)routeFinishes.get(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void listOfRoutesRouter() {
        TestCfg cfg = CfgTestUtils.testTreeWithListOfRoutesRouter();
        ChainExecutionPathTree tree = cfg.getCfgForFlow("flowWithListOfRoutesRouter");
        CountingVisitor visitor = new CountingVisitor();
        tree.accept((ChainExecutionPathTreeVisitor)visitor);
        MatcherAssert.assertThat((Object)visitor.sourceCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.operationCount, (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)visitor.scopeCount, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)visitor.routerCount, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)visitor.errorHandlerCount, (Matcher)CoreMatchers.is((Object)0));
    }
}

