/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.cfg.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.error.ErrorTypeBuilder;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeFactory;
import org.mule.runtime.cfg.utils.MockChainBuilder;

public class TestCfg {
    private final ChainExecutionPathTreeFactory cfgFactory;
    private final Map<String, ComponentAst> flows;

    public static TestCfgBuilder builder() {
        return new TestCfgBuilder();
    }

    private TestCfg(ChainExecutionPathTreeFactory cfgFactory, Map<String, ComponentAst> flows) {
        this.cfgFactory = cfgFactory;
        this.flows = flows;
    }

    public ChainExecutionPathTree getCfgForFlow(String flowName) {
        return this.cfgFactory.generateFor(this.flows.get(flowName));
    }

    private static ArtifactAst getApplication() {
        ArtifactAst application = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        ErrorTypeRepository repository = (ErrorTypeRepository)Mockito.mock(ErrorTypeRepository.class);
        ErrorType parent = ErrorTypeBuilder.builder().identifier("ANY").namespace("MULE").build();
        Mockito.when((Object)repository.lookupErrorType((ComponentIdentifier)ArgumentMatchers.any())).thenAnswer(invocationOnMock -> {
            ComponentIdentifier identifier = (ComponentIdentifier)invocationOnMock.getArgument(0);
            ErrorTypeBuilder builder = ErrorTypeBuilder.builder().identifier(identifier.getName()).namespace(identifier.getNamespace());
            if (!identifier.getName().equals("ANY") || !identifier.getNamespace().equals("MULE")) {
                builder.parentErrorType(parent);
            }
            return Optional.of(builder.build());
        });
        Mockito.when((Object)application.getErrorTypeRepository()).thenReturn((Object)repository);
        return application;
    }

    public static class TestCfgBuilder {
        private final Map<String, ComponentAst> flows = new HashMap<String, ComponentAst>();

        public TestCfgBuilder addFlow(String flowName, Consumer<MockChainBuilder> flowConfigurer) {
            MockChainBuilder flowBuilder = MockChainBuilder.newBuilder(flowName);
            flowConfigurer.accept(flowBuilder);
            this.flows.put(flowName, flowBuilder.build());
            return this;
        }

        public TestCfg build() {
            ArtifactAst application = TestCfg.getApplication();
            Mockito.when((Object)application.topLevelComponentsStream()).then(invocationOnMock -> this.flows.values().stream());
            return new TestCfg(new ChainExecutionPathTreeFactory(application), this.flows);
        }
    }
}

