/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.cfg.utils;

import java.util.Optional;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.nested.ChainExecutionOccurrence;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.error.ErrorTypeBuilder;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeFactory;
import org.mule.runtime.cfg.utils.MockChainBuilder;
import org.mule.runtime.cfg.utils.TestCfg;

public final class CfgTestUtils {
    public static final ComponentIdentifier SET_PAYLODAD = ComponentIdentifier.buildFromStringRepresentation((String)"set-payload");
    public static final ComponentIdentifier SET_VARIABLE = ComponentIdentifier.buildFromStringRepresentation((String)"set-variable");
    public static final ComponentIdentifier LOGGER = ComponentIdentifier.buildFromStringRepresentation((String)"logger");
    public static final ComponentIdentifier FOREACH = ComponentIdentifier.buildFromStringRepresentation((String)"foreach");
    public static final ComponentIdentifier NOOP = ComponentIdentifier.buildFromStringRepresentation((String)"noop");
    public static final ComponentIdentifier NOOP2 = ComponentIdentifier.buildFromStringRepresentation((String)"noop2");
    public static final ComponentIdentifier TRYSCOPE = ComponentIdentifier.buildFromStringRepresentation((String)"try");
    public static final ComponentIdentifier SCATTER_GATHER = ComponentIdentifier.buildFromStringRepresentation((String)"scatter-gather");
    public static final ComponentIdentifier CHOICE = ComponentIdentifier.buildFromStringRepresentation((String)"choice");
    public static final ComponentIdentifier LIST_OF_ROUTES_ROUTER = ComponentIdentifier.buildFromStringRepresentation((String)"list-of-routes-router");
    public static final ComponentIdentifier PARALLEL_FOREACH = ComponentIdentifier.buildFromStringRepresentation((String)"parallel-foreach");
    public static final ComponentIdentifier DB_SELECT = ComponentIdentifier.builder().namespace("db").name("select").build();
    public static final ComponentIdentifier JMS_PUBLISH = ComponentIdentifier.builder().namespace("jms").name("publish").build();
    public static final TestCfg TEST_TREE_WITH_RAISE_ERROR = CfgTestUtils.testTreeWithRaiseError();

    private CfgTestUtils() {
    }

    public static ChainExecutionPathTree testTree() {
        ComponentAst flow = MockChainBuilder.newBuilder("name").addSimpleOperation(LOGGER).addScope(FOREACH, ChainExecutionOccurrence.ONCE_OR_NONE, fe -> fe.addSimpleOperation(LOGGER).addRouter(SCATTER_GATHER, sg -> sg.addRoute(ChainExecutionOccurrence.ONCE, r -> r.addSimpleOperation(SET_PAYLODAD)).addRoute(ChainExecutionOccurrence.ONCE, r -> r.addSimpleOperation(DB_SELECT))).addSimpleOperation(LOGGER)).addRouter(CHOICE, ch -> ch.addRoute(ChainExecutionOccurrence.ONCE_OR_NONE, r -> r.addSimpleOperation(SET_PAYLODAD)).addRoute(ChainExecutionOccurrence.ONCE_OR_NONE, r -> r.addSimpleOperation(SET_VARIABLE).addSimpleOperation(LOGGER))).addScope(TRYSCOPE, ChainExecutionOccurrence.ONCE, tr -> tr.addSimpleOperation(NOOP)).build();
        return new ChainExecutionPathTreeFactory(CfgTestUtils.getApplication()).generateFor(flow);
    }

    public static ChainExecutionPathTree testTreeWithErrorHandling(boolean continueWithAllErrors) {
        ComponentAst flow = MockChainBuilder.newBuilder("name").addSimpleOperation(LOGGER).addScope(TRYSCOPE, ChainExecutionOccurrence.ONCE, fe -> fe.addSimpleOperation(LOGGER).addRouter(CHOICE, sg -> sg.addRoute(ChainExecutionOccurrence.ONCE_OR_NONE, r -> r.addSimpleOperation(SET_PAYLODAD)).addRoute(ChainExecutionOccurrence.ONCE_OR_NONE, r -> r.addSimpleOperationWithErrors(DB_SELECT, "SOME", "OTHER"))).addSimpleOperation(LOGGER).addErrorHandler(eh -> eh.addOnErrorPropagate("TEST:SOME", ep -> ep.addSimpleOperation(SET_VARIABLE).addSimpleOperation(JMS_PUBLISH).addSimpleOperation(NOOP)).addOnErrorContinue(continueWithAllErrors ? null : "TEST:OTHER", ep -> ep.addSimpleOperation(SET_VARIABLE)))).addErrorHandler(eh -> eh.addOnErrorContinue("MULE:NOTHING", ec -> ec.addSimpleOperation(NOOP2)).addOnErrorContinue(null, ec -> ec.addSimpleOperation(SET_VARIABLE))).build();
        return new ChainExecutionPathTreeFactory(CfgTestUtils.getApplication()).generateFor(flow);
    }

    public static TestCfg testTreeWithRaiseError() {
        return TestCfg.builder().addFlow("raiseErrorAtFlowLevelNoErrorHandler", f -> f.addSimpleOperation(LOGGER).addRaiseError("MULE:VALIDATION").addSimpleOperation(LOGGER)).addFlow("raiseErrorAtFlowLevelWithErrorHandler", f -> f.addSimpleOperation(LOGGER).addRaiseError("MULE:VALIDATION").addSimpleOperation(LOGGER).addErrorHandler(eh -> eh.addOnErrorContinue(null, ec -> ec.addSimpleOperation(LOGGER)))).addFlow("raiseErrorAtTryWithMatchingAllOnErrorContinue", f -> f.addSimpleOperation(LOGGER).addScope(TRYSCOPE, ChainExecutionOccurrence.ONCE, tr -> tr.addRaiseError("MULE:VALIDATION").addSimpleOperation(LOGGER).addErrorHandler(eh -> eh.addOnErrorContinue(null, ec -> ec.addSimpleOperation(LOGGER)))).addSimpleOperation(LOGGER)).addFlow("raiseErrorAtTryWithMatchingOnErrorContinue", f -> f.addSimpleOperation(LOGGER).addScope(TRYSCOPE, ChainExecutionOccurrence.ONCE, tr -> tr.addRaiseError("MULE:VALIDATION").addSimpleOperation(LOGGER).addErrorHandler(eh -> eh.addOnErrorContinue("MULE:VALIDATION", ec -> ec.addSimpleOperation(LOGGER)))).addSimpleOperation(LOGGER)).addFlow("raiseErrorAtTryWithMatchingOnErrorContinueWithRaiseError", f -> f.addSimpleOperation(LOGGER).addScope(TRYSCOPE, ChainExecutionOccurrence.ONCE, tr -> tr.addRaiseError("MULE:VALIDATION").addSimpleOperation(LOGGER).addErrorHandler(eh -> eh.addOnErrorContinue("MULE:VALIDATION", ec -> ec.addSimpleOperation(LOGGER).addRaiseError("MULE:NOT_PERMITTED").addSimpleOperation(LOGGER)))).addSimpleOperation(LOGGER)).addFlow("raiseErrorAtTryWithMatchingOnErrorContinueWithRaiseErrorThenAnotherContinue", f -> f.addSimpleOperation(LOGGER).addScope(TRYSCOPE, ChainExecutionOccurrence.ONCE, tr1 -> tr1.addScope(TRYSCOPE, ChainExecutionOccurrence.ONCE, tr2 -> tr2.addRaiseError("MULE:VALIDATION").addSimpleOperation(LOGGER).addErrorHandler(eh -> eh.addOnErrorContinue("MULE:VALIDATION", ec -> ec.addSimpleOperation(LOGGER).addRaiseError("MULE:NOT_PERMITTED").addSimpleOperation(LOGGER)))).addErrorHandler(eh -> eh.addOnErrorContinue("MULE:NOT_PERMITTED", ec -> ec.addSimpleOperation(LOGGER)))).addSimpleOperation(LOGGER)).addFlow("raiseErrorAtTryWithNotMatchingOnErrorContinue", f -> f.addSimpleOperation(LOGGER).addScope(TRYSCOPE, ChainExecutionOccurrence.ONCE, tr -> tr.addRaiseError("MULE:VALIDATION").addSimpleOperation(LOGGER).addErrorHandler(eh -> eh.addOnErrorContinue("MULE:EXPRESSION", ec -> ec.addSimpleOperation(LOGGER)))).addSimpleOperation(LOGGER)).addFlow("raiseErrorAtTryWithMatchingOnErrorPropagate", f -> f.addSimpleOperation(LOGGER).addScope(TRYSCOPE, ChainExecutionOccurrence.ONCE, tr -> tr.addRaiseError("MULE:VALIDATION").addSimpleOperation(LOGGER).addErrorHandler(eh -> eh.addOnErrorPropagate("MULE:VALIDATION", ec -> ec.addSimpleOperation(LOGGER)))).addSimpleOperation(LOGGER)).addFlow("raiseErrorAtChoiceAllRoutes", f -> f.addSimpleOperation(LOGGER).addRouter(CHOICE, tr -> tr.addRoute(ChainExecutionOccurrence.ONCE_OR_NONE, r -> r.addRaiseError("MULE:VALIDATION").addSimpleOperation(LOGGER)).addRoute(ChainExecutionOccurrence.ONCE_OR_NONE, r -> r.addRaiseError("MULE:VALIDATION").addSimpleOperation(LOGGER))).addSimpleOperation(LOGGER)).addFlow("raiseErrorAtChoiceSomeRoutes", f -> f.addSimpleOperation(LOGGER).addRouter(CHOICE, tr -> tr.addRoute(ChainExecutionOccurrence.ONCE_OR_NONE, r -> r.addRaiseError("MULE:VALIDATION").addSimpleOperation(LOGGER))).addSimpleOperation(LOGGER)).addFlow("raiseErrorAtScatterGatherAllRoutes", f -> f.addSimpleOperation(LOGGER).addRouter(SCATTER_GATHER, tr -> tr.addRoute(ChainExecutionOccurrence.ONCE, r -> r.addRaiseError("MULE:VALIDATION").addSimpleOperation(LOGGER)).addRoute(ChainExecutionOccurrence.ONCE, r -> r.addRaiseError("MULE:VALIDATION").addSimpleOperation(LOGGER))).addSimpleOperation(LOGGER)).addFlow("raiseErrorAtReferencedFlowWithNoErrorHandling", f -> f.addFlowRef("raiseErrorAtFlowLevelNoErrorHandler").addSimpleOperation(LOGGER)).addFlow("raiseErrorAtReferencedFlowWithErrorHandling", f -> f.addFlowRef("raiseErrorAtFlowLevelWithErrorHandler").addSimpleOperation(LOGGER)).addFlow("raiseErrorAtRecursiveFlow", f -> f.addSimpleOperation(LOGGER).addScope(TRYSCOPE, ChainExecutionOccurrence.ONCE, tr -> tr.addSimpleOperation(LOGGER).addFlowRef("raiseErrorAtRecursiveFlow")).addRaiseError("MULE:VALIDATION").addSimpleOperation(LOGGER)).build();
    }

    public static TestCfg testTreeWithEmptyRoutes() {
        return TestCfg.builder().addFlow("flowWithEmptyRoutes", f -> f.addRouter(CHOICE, sg -> sg.addRoute(ChainExecutionOccurrence.ONCE_OR_NONE, r -> {}).addRoute(ChainExecutionOccurrence.ONCE_OR_NONE, r -> {}))).build();
    }

    public static TestCfg testTreeWithListOfRoutesRouter() {
        return TestCfg.builder().addFlow("flowWithListOfRoutesRouter", f -> f.addRouter(LIST_OF_ROUTES_ROUTER, sg -> sg.addListOfRoutes(ChainExecutionOccurrence.ONCE_OR_NONE, 3, r -> r.addSimpleOperation(LOGGER)))).build();
    }

    private static ArtifactAst getApplication() {
        ArtifactAst application = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        ErrorTypeRepository repository = (ErrorTypeRepository)Mockito.mock(ErrorTypeRepository.class);
        ErrorType parent = ErrorTypeBuilder.builder().identifier("ANY").namespace("MULE").build();
        Mockito.when((Object)repository.lookupErrorType((ComponentIdentifier)ArgumentMatchers.any())).thenAnswer(invocationOnMock -> {
            ComponentIdentifier identifier = (ComponentIdentifier)invocationOnMock.getArgument(0);
            ErrorTypeBuilder builder = ErrorTypeBuilder.builder().identifier(identifier.getName()).namespace(identifier.getNamespace());
            if (!identifier.getName().equals("ANY") || !identifier.getNamespace().equals("MULE")) {
                builder.parentErrorType(parent);
            }
            return Optional.of(builder.build());
        });
        Mockito.when((Object)application.getErrorTypeRepository()).thenReturn((Object)repository);
        return application;
    }

    public static boolean hasIdentifier(ChainExecutionPathTree tree, ComponentIdentifier identifier) {
        return tree.getComponentAst().getIdentifier().equals(identifier);
    }
}

