/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.cfg.internal.queries;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.utils.CfgTestUtils;

@Feature(value="Control Flow Graph")
@Story(value="Query process to the CFG Tree")
public class ErrorHandlingQueriesTestCase {
    private ChainExecutionPathTree tree;

    @Before
    public void setup() {
        this.tree = CfgTestUtils.testTreeWithErrorHandling(true);
    }

    @Test
    public void inAnErrorHandler() {
        MatcherAssert.assertThat((Object)this.tree.anyExecutionPathContains(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.JMS_PUBLISH)), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.tree.allExecutionPathsContain(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.JMS_PUBLISH)), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.tree.noneExecutionPathsContains(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.JMS_PUBLISH)), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void inErrorHandlerButNotIfNoError() {
        MatcherAssert.assertThat((Object)this.tree.anyExecutionPathContains(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.SET_VARIABLE)), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.tree.allExecutionPathsContain(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.SET_VARIABLE)), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.tree.noneExecutionPathsContains(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.SET_VARIABLE)), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void inAllRoutes() {
        MatcherAssert.assertThat((Object)this.tree.anyExecutionPathContains(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.LOGGER)), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.tree.allExecutionPathsContain(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.LOGGER)), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.tree.noneExecutionPathsContains(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.LOGGER)), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void notInAllRoutesIfAfterOperationWithPotentialError() {
        MatcherAssert.assertThat((Object)this.tree.anyExecutionPathContains(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.NOOP)), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.tree.allExecutionPathsContain(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.NOOP)), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.tree.noneExecutionPathsContains(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.NOOP)), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void elementNotPresent() {
        MatcherAssert.assertThat((Object)this.tree.anyExecutionPathContains(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.PARALLEL_FOREACH)), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.tree.allExecutionPathsContain(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.PARALLEL_FOREACH)), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.tree.noneExecutionPathsContains(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.PARALLEL_FOREACH)), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void elementNotPresentForElementDeclaredInUnexecutedErrorHandler() {
        MatcherAssert.assertThat((Object)this.tree.anyExecutionPathContains(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.NOOP2)), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.tree.allExecutionPathsContain(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.NOOP2)), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.tree.noneExecutionPathsContains(tree -> CfgTestUtils.hasIdentifier(tree, CfgTestUtils.NOOP2)), (Matcher)CoreMatchers.is((Object)true));
    }
}

