/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.test.internal.builder;

import static org.mule.runtime.ast.test.AllureConstants.ArtifactAst.ARTIFACT_AST;
import static org.mule.runtime.ast.test.AllureConstants.ArtifactAst.AstConstruction.NAMESPACE_ARTIFACT_AST_CONSTRUCTION;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.collection.IsCollectionWithSize.hasSize;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.junit.Test;
import org.mule.runtime.ast.api.NamespaceDefinition;
import org.mule.runtime.ast.api.builder.NamespaceDefinitionBuilder;

@Feature(ARTIFACT_AST)
@Story(NAMESPACE_ARTIFACT_AST_CONSTRUCTION)
public class DefaultNamespaceDefinitionBuilderTestCase {

  @Test
  public void testBuilder() {
    NamespaceDefinition namespaceDefinition = NamespaceDefinitionBuilder.builder()
        .withNamespace("some")
        .withPrefix("thePrefix")
        .withSchemaLocation("theNamespace", "theSchemaLocation")
        .build();
    assertThat(namespaceDefinition.getNamespace(), is("some"));
    assertThat(namespaceDefinition.getPrefix(), is("thePrefix"));
    assertThat(namespaceDefinition.getSchemaLocations().keySet(), hasSize(1));
    assertThat(namespaceDefinition.getSchemaLocations().get("theNamespace"), is("theSchemaLocation"));
    assertThat(namespaceDefinition.getUnresovedNamespaces().keySet(), hasSize(0));
  }

}
