/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.error;

import static org.mule.runtime.api.util.classloader.MuleImplementationLoaderUtils.getMuleImplementationsLoader;
import static org.mule.runtime.api.util.classloader.MuleImplementationLoaderUtils.isResolveMuleImplementationLoadersDynamically;
import static org.mule.runtime.ast.api.error.ErrorTypeRepositoryProvider.CORE_ERROR_TYPE_REPO;

import static java.util.ServiceLoader.load;

import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.ast.api.error.ErrorTypeRepositoryProvider;

/**
 * Default implementation of {@link ErrorTypeRepositoryProvider}.
 */
public class DefaultErrorTypeRepositoryProvider {

  private static ErrorTypeRepository loadErrorTypeRepository() {
    return load(ErrorTypeRepositoryProvider.class, getMuleImplementationsLoader())
        .iterator().next()
        .get();
  }

  public ErrorTypeRepository getCoreErrorTypeRepo() {
    if (isResolveMuleImplementationLoadersDynamically()) {
      return loadErrorTypeRepository();
    } else {
      return CORE_ERROR_TYPE_REPO.get();
    }
  }

}
