/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.api.error;

import static org.mule.runtime.api.util.classloader.MuleImplementationLoaderUtils.getMuleImplementationsLoader;

import static java.util.ServiceLoader.load;

import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.internal.error.DefaultErrorTypeRepositoryProvider;

import java.util.function.Supplier;

/**
 * Allows the AST module to discover the errors declared by the runtime.
 * <p>
 * Instances of this class are discovered through SPI using the same classloader as the one used to load the AST module classes.
 */
public interface ErrorTypeRepositoryProvider extends Supplier<ErrorTypeRepository> {

  LazyValue<ErrorTypeRepository> CORE_ERROR_TYPE_REPO =
      new LazyValue<>(() -> load(ErrorTypeRepositoryProvider.class, getMuleImplementationsLoader())
          .iterator().next()
          .get());

  static ErrorTypeRepository getCoreErrorTypeRepo() {
    return new DefaultErrorTypeRepositoryProvider().getCoreErrorTypeRepo();
  }

}
