/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.validation;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.ArtifactAstValidator;
import org.mule.runtime.ast.api.validation.ArtifactValidation;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationsProvider;

@Feature(value="Mule Artifact AST")
@Story(value="Validations")
public class ArtifactAstValidationTestCase {
    private Validation validation;
    private ArtifactValidation artifactValidation;
    private TestValidationProvider testValidationProvider;
    private ArtifactAst ast;
    private ComponentAst component;

    @Before
    public void setUp() {
        this.validation = (Validation)Mockito.mock(Validation.class);
        this.artifactValidation = (ArtifactValidation)Mockito.mock(ArtifactValidation.class);
        this.testValidationProvider = new TestValidationProvider();
        this.ast = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        this.component = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)this.ast.topLevelComponentsStream()).thenAnswer(inv -> Stream.of(this.component));
    }

    private void configureValidationProviderLoaders(MockedStatic<ServiceLoader> loaderClass) {
        ServiceLoader fromRuntimeLoader = (ServiceLoader)Mockito.mock(ServiceLoader.class);
        Mockito.when(fromRuntimeLoader.spliterator()).thenReturn(Collections.singletonList(this.testValidationProvider).spliterator());
        ServiceLoader fromExtensionsLoader = (ServiceLoader)Mockito.mock(ServiceLoader.class);
        Mockito.when(fromExtensionsLoader.spliterator()).thenReturn(Collections.emptyList().spliterator());
        loaderClass.when(() -> ServiceLoader.load(ValidationsProvider.class)).thenReturn((Object)fromRuntimeLoader);
        loaderClass.when(() -> ServiceLoader.load((Class)ArgumentMatchers.eq(ValidationsProvider.class), (ClassLoader)ArgumentMatchers.any(ClassLoader.class))).thenReturn((Object)fromExtensionsLoader);
    }

    @Test
    public void validationsCalledOnAst() {
        ArtifactAstValidator validator;
        try (MockedStatic loaderClass = Mockito.mockStatic(ServiceLoader.class);){
            this.configureValidationProviderLoaders((MockedStatic<ServiceLoader>)loaderClass);
            validator = MuleAstUtils.validatorBuilder().build();
        }
        MatcherAssert.assertThat((Object)this.testValidationProvider.getArtifactRegionClassLoader(), (Matcher)Is.is((Object)Thread.currentThread().getContextClassLoader()));
        MatcherAssert.assertThat((Object)this.testValidationProvider.isIgnoreParamsWithProperties(), (Matcher)Is.is((Object)false));
        this.verifyValidationsInvoked(validator);
    }

    @Test
    public void validationsNotApplicableNotCalledOnAst() {
        ArtifactAstValidator validator;
        try (MockedStatic loaderClass = Mockito.mockStatic(ServiceLoader.class);){
            this.configureValidationProviderLoaders((MockedStatic<ServiceLoader>)loaderClass);
            validator = MuleAstUtils.validatorBuilder().build();
        }
        MatcherAssert.assertThat((Object)this.testValidationProvider.getArtifactRegionClassLoader(), (Matcher)Is.is((Object)Thread.currentThread().getContextClassLoader()));
        MatcherAssert.assertThat((Object)this.testValidationProvider.isIgnoreParamsWithProperties(), (Matcher)Is.is((Object)false));
        Mockito.when((Object)this.validation.applicable()).thenReturn(h -> false);
        validator.validate(this.ast);
        ((Validation)Mockito.verify((Object)this.validation)).applicable();
        ((Validation)Mockito.verify((Object)this.validation, (VerificationMode)Mockito.never())).validateMany(this.component, this.ast);
        ((ArtifactValidation)Mockito.verify((Object)this.artifactValidation)).validateMany(this.ast);
    }

    @Test
    public void validationEnricher() {
        ArtifactAstValidator validator;
        Consumer enricher = (Consumer)Mockito.mock(Consumer.class);
        try (MockedStatic loaderClass = Mockito.mockStatic(ServiceLoader.class);){
            this.configureValidationProviderLoaders((MockedStatic<ServiceLoader>)loaderClass);
            validator = MuleAstUtils.validatorBuilder().withValidationEnricher(enricher).build();
        }
        ((Consumer)Mockito.verify((Object)enricher)).accept(this.testValidationProvider);
        MatcherAssert.assertThat((Object)this.testValidationProvider.getArtifactRegionClassLoader(), (Matcher)Is.is((Object)Thread.currentThread().getContextClassLoader()));
        MatcherAssert.assertThat((Object)this.testValidationProvider.isIgnoreParamsWithProperties(), (Matcher)Is.is((Object)false));
        this.verifyValidationsInvoked(validator);
    }

    @Test
    public void validationsFilter() {
        ArtifactAstValidator validator;
        try (MockedStatic loaderClass = Mockito.mockStatic(ServiceLoader.class);){
            this.configureValidationProviderLoaders((MockedStatic<ServiceLoader>)loaderClass);
            validator = MuleAstUtils.validatorBuilder().withValidationsFilter(v -> false).build();
        }
        MatcherAssert.assertThat((Object)this.testValidationProvider.getArtifactRegionClassLoader(), (Matcher)Is.is((Object)Thread.currentThread().getContextClassLoader()));
        MatcherAssert.assertThat((Object)this.testValidationProvider.isIgnoreParamsWithProperties(), (Matcher)Is.is((Object)false));
        Mockito.when((Object)this.validation.applicable()).thenReturn(h -> true);
        validator.validate(this.ast);
        ((Validation)Mockito.verify((Object)this.validation, (VerificationMode)Mockito.never())).applicable();
        ((Validation)Mockito.verify((Object)this.validation, (VerificationMode)Mockito.never())).validateMany(this.component, this.ast);
        ((ArtifactValidation)Mockito.verify((Object)this.artifactValidation, (VerificationMode)Mockito.never())).validateMany(this.ast);
    }

    @Test
    public void artifactRegionClassLoader() {
        ArtifactAstValidator validator;
        ClassLoader artifactRegionClassLoader = new ClassLoader(this.getClass().getClassLoader()){};
        try (MockedStatic loaderClass = Mockito.mockStatic(ServiceLoader.class);){
            this.configureValidationProviderLoaders((MockedStatic<ServiceLoader>)loaderClass);
            validator = MuleAstUtils.validatorBuilder().withArtifactRegionClassLoader(artifactRegionClassLoader).build();
        }
        MatcherAssert.assertThat((Object)this.testValidationProvider.getArtifactRegionClassLoader(), (Matcher)Is.is((Object)artifactRegionClassLoader));
        MatcherAssert.assertThat((Object)this.testValidationProvider.isIgnoreParamsWithProperties(), (Matcher)Is.is((Object)false));
        this.verifyValidationsInvoked(validator);
    }

    @Test
    public void ignoreParamsWithProperties() {
        ArtifactAstValidator validator;
        ClassLoader artifactRegionClassLoader = new ClassLoader(this.getClass().getClassLoader()){};
        try (MockedStatic loaderClass = Mockito.mockStatic(ServiceLoader.class);){
            this.configureValidationProviderLoaders((MockedStatic<ServiceLoader>)loaderClass);
            validator = MuleAstUtils.validatorBuilder().ignoreParamsWithProperties(true).build();
        }
        MatcherAssert.assertThat((Object)this.testValidationProvider.getArtifactRegionClassLoader(), (Matcher)Is.is((Object)Thread.currentThread().getContextClassLoader()));
        MatcherAssert.assertThat((Object)this.testValidationProvider.isIgnoreParamsWithProperties(), (Matcher)Is.is((Object)true));
        this.verifyValidationsInvoked(validator);
    }

    private void verifyValidationsInvoked(ArtifactAstValidator validator) {
        Mockito.when((Object)this.validation.applicable()).thenReturn(h -> true);
        validator.validate(this.ast);
        ((Validation)Mockito.verify((Object)this.validation)).applicable();
        ((Validation)Mockito.verify((Object)this.validation)).validateMany(this.component, this.ast);
        ((ArtifactValidation)Mockito.verify((Object)this.artifactValidation)).validateMany(this.ast);
    }

    public class TestValidationProvider
    implements ValidationsProvider {
        private ClassLoader artifactRegionClassLoader;
        private boolean ignoreParamsWithProperties;

        public ClassLoader getArtifactRegionClassLoader() {
            return this.artifactRegionClassLoader;
        }

        public void setArtifactRegionClassLoader(ClassLoader artifactRegionClassLoader) {
            this.artifactRegionClassLoader = artifactRegionClassLoader;
        }

        public boolean isIgnoreParamsWithProperties() {
            return this.ignoreParamsWithProperties;
        }

        public void setIgnoreParamsWithProperties(boolean ignoreParamsWithProperties) {
            this.ignoreParamsWithProperties = ignoreParamsWithProperties;
        }

        public List<Validation> get() {
            return Collections.singletonList(ArtifactAstValidationTestCase.this.validation);
        }

        public List<ArtifactValidation> getArtifactValidations() {
            return Collections.singletonList(ArtifactAstValidationTestCase.this.artifactValidation);
        }
    }
}

