/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.builder;

import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.internal.builder.DefaultImportedResourceBuilder;

public class DefaultImportedResourceBuilderTestCase {
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();
    @Mock
    private ComponentMetadataAst metadata;
    private DefaultImportedResourceBuilder builder;

    @Before
    public void setUp() throws Exception {
        this.builder = new DefaultImportedResourceBuilder();
    }

    @Test(expected=NullPointerException.class)
    public void buildWithNoSetup() {
        this.builder.build();
    }

    @Test(expected=NullPointerException.class)
    public void buildWithOnlyLocation() {
        this.builder.withResourceLocation("foo").build();
    }

    @Test
    public void buildMinimalGood() {
        ImportedResource result = this.builder.withMetadata(this.metadata).withResourceLocation("foo").build();
        MatcherAssert.assertThat((Object)result.getMetadata(), (Matcher)CoreMatchers.is((Object)this.metadata));
        MatcherAssert.assertThat((Object)result.getRawResourceLocation(), (Matcher)CoreMatchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)result.getRawResourceLocation(), (Matcher)CoreMatchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)result.getResolutionFailure(), (Matcher)CoreMatchers.is(Optional.empty()));
    }

    @Test
    public void buildWithErrorGood() {
        ImportedResource result = this.builder.withMetadata(this.metadata).withResourceLocation("foo").withResolutionFailure("Blarf").build();
        MatcherAssert.assertThat((Object)result.getMetadata(), (Matcher)CoreMatchers.is((Object)this.metadata));
        MatcherAssert.assertThat((Object)result.getRawResourceLocation(), (Matcher)CoreMatchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)result.getResolutionFailure(), (Matcher)CoreMatchers.is(Optional.of("Blarf")));
    }
}

