/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.builder;

import static java.lang.String.format;

import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;

import java.util.Objects;

public class ParameterKey {

  private final ParameterGroupModel paramGroup;
  private final ParameterModel param;

  public ParameterKey(ParameterGroupModel paramGroup, ParameterModel param) {
    this.paramGroup = paramGroup;
    this.param = param;
  }

  public ParameterGroupModel getParamGroup() {
    return paramGroup;
  }

  public String getParamGroupName() {
    return paramGroup.getName();
  }

  public ParameterModel getParam() {
    return param;
  }

  public String getParamName() {
    return param.getName();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return format("{%s:%s}", paramGroup, param);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int hashCode() {
    return Objects.hash(paramGroup, param);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object o) {
    if (o instanceof ParameterKey) {
      ParameterKey other = (ParameterKey) o;
      return Objects.equals(paramGroup, other.getParamGroup()) && Objects.equals(param, other.getParam());
    }

    return false;
  }
}
