/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.builder;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableWithSize;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.ast.api.model.ExtensionModelHelper;
import org.mule.runtime.ast.internal.builder.ComponentLocationVisitor;
import org.mule.runtime.ast.internal.builder.DefaultComponentAstBuilder;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.model.ParameterModelUtils;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;

@Feature(value="Mule Artifact AST")
@Story(value="Parameter AST resolution")
public class ComponentAstParameterBuilderTestCase {
    private static final XmlDslModel XML_DSL_MODEL = XmlDslModel.builder().setPrefix("mockns").setNamespace("http://mockns").build();
    private static final ComponentIdentifier COMPONENT_ID = ComponentIdentifier.builder().namespaceUri(XML_DSL_MODEL.getNamespace()).namespace(XML_DSL_MODEL.getPrefix()).name("component").build();
    private PropertiesResolver propertiesResolver;
    private ExtensionModelHelper extensionModelHelper;
    private ComponentLocationVisitor componentLocationVisitor;
    private ParameterModelUtils parameterModelUtils;
    private ParameterGroupModel paramGroup;
    private ParameterModel simpleParam;
    private ParameterModel complexParam;
    private ParameterModel listComplexParam;

    @Before
    public void before() {
        this.paramGroup = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)this.paramGroup.getName()).thenReturn((Object)"group");
        this.simpleParam = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)this.simpleParam.getType()).thenReturn((Object)new DefaultStringType(null, null));
        Mockito.when((Object)this.simpleParam.getName()).thenReturn((Object)"simpleParam");
        this.complexParam = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)this.complexParam.getName()).thenReturn((Object)"complexParam");
        this.listComplexParam = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)this.listComplexParam.getName()).thenReturn((Object)"listComplexParam");
        this.propertiesResolver = (PropertiesResolver)Mockito.mock(PropertiesResolver.class);
        this.extensionModelHelper = (ExtensionModelHelper)Mockito.mock(ExtensionModelHelper.class);
        DslElementSyntax simpleParamSyntax = (DslElementSyntax)Mockito.mock(DslElementSyntax.class);
        Mockito.when((Object)simpleParamSyntax.getElementName()).thenReturn((Object)"simple-param");
        Mockito.when((Object)this.extensionModelHelper.resolveDslElementModel(this.simpleParam, COMPONENT_ID)).thenReturn((Object)simpleParamSyntax);
        DslElementSyntax complexParamSyntax = (DslElementSyntax)Mockito.mock(DslElementSyntax.class);
        Mockito.when((Object)complexParamSyntax.getElementName()).thenReturn((Object)"complex-param");
        Mockito.when((Object)this.extensionModelHelper.resolveDslElementModel(this.complexParam, COMPONENT_ID)).thenReturn((Object)complexParamSyntax);
        DslElementSyntax listComplexParamSyntax = (DslElementSyntax)Mockito.mock(DslElementSyntax.class);
        Mockito.when((Object)listComplexParamSyntax.getElementName()).thenReturn((Object)"list-complex-param");
        Mockito.when((Object)this.extensionModelHelper.resolveDslElementModel(this.listComplexParam, COMPONENT_ID)).thenReturn((Object)listComplexParamSyntax);
        this.parameterModelUtils = (ParameterModelUtils)Mockito.mock(ParameterModelUtils.class);
        this.componentLocationVisitor = (ComponentLocationVisitor)Mockito.mock(ComponentLocationVisitor.class);
    }

    @Test
    public void syntaxTwice() {
        DefaultComponentAstBuilder componentAstBuilder = new DefaultComponentAstBuilder(this.propertiesResolver, this.extensionModelHelper, null, 0, this.componentLocationVisitor, this.parameterModelUtils);
        Assert.assertThrows(IllegalStateException.class, () -> componentAstBuilder.addParameter(this.complexParam, this.paramGroup, configurer -> configurer.withSyntax((DslElementSyntax)Mockito.mock(DslElementSyntax.class)).withSyntax((DslElementSyntax)Mockito.mock(DslElementSyntax.class))));
    }

    @Test
    public void simpleValue() {
        ComponentAstBuilder componentAstBuilder = new DefaultComponentAstBuilder(this.propertiesResolver, this.extensionModelHelper, null, 0, this.componentLocationVisitor, this.parameterModelUtils).withIdentifier(COMPONENT_ID).withMetadata((ComponentMetadataAst)Mockito.mock(ComponentMetadataAst.class)).withParameterizedModel((ParameterizedModel)Mockito.mock(ParameterizedModel.class));
        componentAstBuilder.addParameter(this.simpleParam, this.paramGroup, configurer -> configurer.withSyntax(null).withMetadata(null).withValue("simple"));
        ComponentAst built = componentAstBuilder.build();
        MatcherAssert.assertThat((Object)built.getParameters(), (Matcher)IsIterableWithSize.iterableWithSize((int)1));
        ComponentParameterAst builtParam = built.getParameter(this.paramGroup.getName(), this.simpleParam.getName());
        MatcherAssert.assertThat((Object)builtParam.getValue().getRight(), (Matcher)Matchers.is((Object)"simple"));
    }

    @Test
    public void complexValue() {
        ComponentAstBuilder componentAstBuilder = new DefaultComponentAstBuilder(this.propertiesResolver, this.extensionModelHelper, null, 0, this.componentLocationVisitor, this.parameterModelUtils).withIdentifier(COMPONENT_ID).withMetadata((ComponentMetadataAst)Mockito.mock(ComponentMetadataAst.class)).withParameterizedModel((ParameterizedModel)Mockito.mock(ParameterizedModel.class));
        componentAstBuilder.addParameter(this.complexParam, this.paramGroup, configurer -> configurer.withSyntax(null).withMetadata(null).withValue((ComponentAstBuilder)this.mockCmplexValueBuilder()));
        ComponentAst built = componentAstBuilder.build();
        MatcherAssert.assertThat((Object)built.getParameters(), (Matcher)IsIterableWithSize.iterableWithSize((int)1));
        ComponentParameterAst builtParam = built.getParameter(this.paramGroup.getName(), this.complexParam.getName());
        MatcherAssert.assertThat((Object)builtParam.getValue().getRight(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)builtParam.getValue().getRight(), (Matcher)Matchers.instanceOf(ComponentAst.class));
    }

    @Test
    public void listComplexValue() {
        ComponentAstBuilder componentAstBuilder = new DefaultComponentAstBuilder(this.propertiesResolver, this.extensionModelHelper, null, 0, this.componentLocationVisitor, this.parameterModelUtils).withIdentifier(COMPONENT_ID).withMetadata((ComponentMetadataAst)Mockito.mock(ComponentMetadataAst.class)).withParameterizedModel((ParameterizedModel)Mockito.mock(ParameterizedModel.class));
        componentAstBuilder.addParameter(this.listComplexParam, this.paramGroup, configurer -> configurer.withSyntax(null).withMetadata(null).withValue(Arrays.asList(this.mockCmplexValueBuilder(), this.mockCmplexValueBuilder(), this.mockCmplexValueBuilder())));
        ComponentAst built = componentAstBuilder.build();
        MatcherAssert.assertThat((Object)built.getParameters(), (Matcher)IsIterableWithSize.iterableWithSize((int)1));
        ComponentParameterAst builtParam = built.getParameter(this.paramGroup.getName(), this.listComplexParam.getName());
        List builtValue = (List)builtParam.getValue().getRight();
        MatcherAssert.assertThat((Object)builtValue, (Matcher)IsIterableWithSize.iterableWithSize((int)3));
        MatcherAssert.assertThat((Object)((ComponentAst)builtValue.get(0)), (Matcher)Matchers.instanceOf(ComponentAst.class));
        MatcherAssert.assertThat((Object)((ComponentAst)builtValue.get(1)), (Matcher)Matchers.instanceOf(ComponentAst.class));
        MatcherAssert.assertThat((Object)((ComponentAst)builtValue.get(2)), (Matcher)Matchers.instanceOf(ComponentAst.class));
    }

    private DefaultComponentAstBuilder mockCmplexValueBuilder() {
        DefaultComponentAstBuilder builder = (DefaultComponentAstBuilder)Mockito.mock(DefaultComponentAstBuilder.class);
        Mockito.when((Object)builder.build()).thenReturn((Object)((ComponentAst)Mockito.mock(ComponentAst.class)));
        return builder;
    }
}

