/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.param;

import org.mule.runtime.api.meta.model.parameter.ParameterModel;

import java.util.Optional;

public interface ExpressionAwareParameter {

  String DEFAULT_EXPRESSION_PREFIX = "#[";
  String DEFAULT_EXPRESSION_SUFFIX = "]";

  /**
   * @return the model that represents this parameter.
   */
  ParameterModel getModel();

  /**
   * Parse the given value and remove expression markers if it is considered as an expression.
   *
   * @param value Value to parse
   * @return a Optional containing the expression without markers, empty if the value is not an expression.
   */
  Optional<String> extractExpression(Object value);

  /**
   * Checks if the {@value} is an expression.
   *
   * @param value
   * @return {@code true} if the {@value} is an expression.
   */
  boolean isExpression(Object value);

}
