/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.builder;

import static java.util.Objects.requireNonNull;

import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.internal.DefaultImportedResource;

public class DefaultImportedResourceBuilder implements ImportedResourceBuilder {

  private String resourceLocation;
  private ComponentMetadataAst metadata;
  private String failureMessage;

  @Override
  public ImportedResourceBuilder withResourceLocation(String resourceLocation) {
    this.resourceLocation = resourceLocation;
    return this;
  }

  @Override
  public ImportedResourceBuilder withMetadata(ComponentMetadataAst metadata) {
    this.metadata = metadata;
    return this;
  }

  @Override
  public ImportedResourceBuilder withResolutionFailure(String failureMessage) {
    this.failureMessage = failureMessage;
    return this;
  }

  @Override
  public ImportedResource build() {
    requireNonNull(resourceLocation, "Resource location can't be null for an imported resource");
    requireNonNull(metadata, "Metadata can't be null for an imported resource");
    return new DefaultImportedResource(resourceLocation, metadata, failureMessage);
  }
}
