/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.api.builder;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapWithSize;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.FieldValueProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.builder.ArtifactAstBuilder;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.ast.internal.DefaultComponentMetadataAst;
import org.mule.runtime.ast.internal.DefaultComponentParameterAst;
import org.mule.runtime.ast.internal.builder.BaseComponentAstBuilder;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.builder.adapter.MetadataTypeModelAdapter;
import org.mule.runtime.ast.internal.model.ParameterModelUtils;
import org.mule.runtime.ast.test.api.util.TestUtils;
import org.mule.runtime.ast.test.internal.builder.ApplicationModelTypeUtilsTestCase;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;

@Feature(value="Mule Artifact AST")
@Story(value="AST construction")
public class ComponentAstBuilderTestCase {
    private static final String FLAT_PARAM_NAME = "flat";
    private static final String INGROUP_PARAM_NAME = "inGroup";
    private ParameterModel flatParameterModel;
    private ParameterModel inGroupParameterModel;
    private ParameterModel inGroupCollidingParameterModel;
    private ParameterGroupModel showInDslGroup;
    private ParameterGroupModel showInDslCollidingGroup;
    private ParameterGroupModel defaultGroup;
    private ParameterizedModel parameterized;
    private SourceModel sourceParameterized;

    @Before
    public void before() {
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(ApplicationModelTypeUtilsTestCase.class.getClassLoader());
        MetadataType stringType = typeLoader.load(String.class);
        this.flatParameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)this.flatParameterModel.getName()).thenReturn((Object)FLAT_PARAM_NAME);
        Mockito.when((Object)this.flatParameterModel.getType()).thenReturn((Object)stringType);
        this.inGroupParameterModel = new NonMockParameterModel(INGROUP_PARAM_NAME, stringType);
        this.defaultGroup = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)this.defaultGroup.isShowInDsl()).thenReturn((Object)false);
        Mockito.when((Object)this.defaultGroup.getName()).thenReturn((Object)"Default");
        Mockito.when((Object)this.defaultGroup.getParameterModels()).thenReturn(Arrays.asList(this.flatParameterModel));
        Mockito.when((Object)this.defaultGroup.getParameter(FLAT_PARAM_NAME)).thenReturn(Optional.of(this.flatParameterModel));
        this.showInDslGroup = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)this.showInDslGroup.isShowInDsl()).thenReturn((Object)true);
        Mockito.when((Object)this.showInDslGroup.getName()).thenReturn((Object)"Show in DSL");
        Mockito.when((Object)this.showInDslGroup.getParameterModels()).thenReturn(Arrays.asList(this.inGroupParameterModel));
        Mockito.when((Object)this.showInDslGroup.getParameter(INGROUP_PARAM_NAME)).thenReturn(Optional.of(this.inGroupParameterModel));
        this.parameterized = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        Mockito.when((Object)this.parameterized.getAllParameterModels()).thenReturn(Arrays.asList(this.flatParameterModel, this.inGroupParameterModel));
        Mockito.when((Object)this.parameterized.getParameterGroupModels()).thenReturn(Arrays.asList(this.defaultGroup, this.showInDslGroup));
        this.inGroupCollidingParameterModel = new NonMockParameterModel(INGROUP_PARAM_NAME, stringType);
        this.showInDslCollidingGroup = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)this.showInDslCollidingGroup.isShowInDsl()).thenReturn((Object)true);
        Mockito.when((Object)this.showInDslCollidingGroup.getName()).thenReturn((Object)"Show in DSL Colliding");
        Mockito.when((Object)this.showInDslCollidingGroup.getParameterModels()).thenReturn(Arrays.asList(this.inGroupCollidingParameterModel));
        Mockito.when((Object)this.showInDslCollidingGroup.getParameter(INGROUP_PARAM_NAME)).thenReturn(Optional.of(this.inGroupCollidingParameterModel));
        this.sourceParameterized = (SourceModel)Mockito.mock(SourceModel.class);
        SourceCallbackModel successCallback = (SourceCallbackModel)Mockito.mock(SourceCallbackModel.class);
        Mockito.when((Object)successCallback.getAllParameterModels()).thenReturn(Arrays.asList(this.inGroupParameterModel));
        Mockito.when((Object)successCallback.getParameterGroupModels()).thenReturn(Arrays.asList(this.showInDslGroup));
        SourceCallbackModel errorCallback = (SourceCallbackModel)Mockito.mock(SourceCallbackModel.class);
        Mockito.when((Object)errorCallback.getAllParameterModels()).thenReturn(Arrays.asList(this.inGroupCollidingParameterModel));
        Mockito.when((Object)errorCallback.getParameterGroupModels()).thenReturn(Arrays.asList(this.showInDslCollidingGroup));
        Mockito.when((Object)this.sourceParameterized.getSuccessCallback()).thenReturn(Optional.of(successCallback));
        Mockito.when((Object)this.sourceParameterized.getErrorCallback()).thenReturn(Optional.of(errorCallback));
        Mockito.when((Object)this.sourceParameterized.getAllParameterModels()).thenReturn(Arrays.asList(this.flatParameterModel, this.inGroupParameterModel, this.inGroupCollidingParameterModel));
        Mockito.when((Object)this.sourceParameterized.getParameterGroupModels()).thenReturn(Arrays.asList(this.defaultGroup));
    }

    @Test
    public void lightNoMetadata() {
        ComponentAst comp = ComponentAstBuilder.builder().build();
        MatcherAssert.assertThat((Object)comp.getMetadata(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)comp.getMetadata().getParserAttributes(), (Matcher)Matchers.is((Matcher)IsMapWithSize.anEmptyMap()));
        MatcherAssert.assertThat((Object)comp.getMetadata().getDocAttributes(), (Matcher)Matchers.is((Matcher)IsMapWithSize.anEmptyMap()));
        MatcherAssert.assertThat((Object)comp.getMetadata().getFileName(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)comp.getMetadata().getSourceCode(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)comp.getMetadata().getStartColumn(), (Matcher)Matchers.is((Object)OptionalInt.empty()));
        MatcherAssert.assertThat((Object)comp.getMetadata().getEndColumn(), (Matcher)Matchers.is((Object)OptionalInt.empty()));
        MatcherAssert.assertThat((Object)comp.getMetadata().getStartLine(), (Matcher)Matchers.is((Object)OptionalInt.empty()));
        MatcherAssert.assertThat((Object)comp.getMetadata().getEndLine(), (Matcher)Matchers.is((Object)OptionalInt.empty()));
    }

    @Test
    public void noMetadata() {
        Assert.assertThrows((String)"metadata", NullPointerException.class, () -> ArtifactAstBuilder.builder(Collections.emptySet(), null).addTopLevelComponent().withIdentifier(ComponentIdentifier.buildFromStringRepresentation((String)"ns:comp")).build());
    }

    @Test
    public void withSimpleParamInFlatGroup() {
        BaseComponentAstBuilder componentBuilder = (BaseComponentAstBuilder)ArtifactAstBuilder.builder(Collections.emptySet(), null).addTopLevelComponent().withIdentifier(ComponentIdentifier.buildFromStringRepresentation((String)"ns:comp")).withMetadata(DefaultComponentMetadataAst.builder().build());
        componentBuilder.withParameter(this.flatParameterModel, this.defaultGroup, (ComponentParameterAst)new DefaultComponentParameterAst("value", this.flatParameterModel, TestUtils.createMockParameterGroup(new ParameterModel[0]), (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), new PropertiesResolver(), new ParameterModelUtils()), Optional.empty());
        componentBuilder.withParameterizedModel(this.parameterized);
        componentBuilder.getGenerationInformation().withSyntax((DslElementSyntax)Mockito.mock(DslElementSyntax.class));
        ComponentAst comp = componentBuilder.build();
        MatcherAssert.assertThat((Object)comp.getParameter("General", FLAT_PARAM_NAME).getRawValue(), (Matcher)Matchers.is((Object)"value"));
        MatcherAssert.assertThat((Object)comp.getParameter("General", FLAT_PARAM_NAME).getValue().getRight(), (Matcher)Matchers.is((Object)"value"));
    }

    @Test
    public void withSimpleParamInDslGroup() {
        BaseComponentAstBuilder componentBuilder = (BaseComponentAstBuilder)ArtifactAstBuilder.builder(Collections.emptySet(), null).addTopLevelComponent().withIdentifier(ComponentIdentifier.buildFromStringRepresentation((String)"ns:comp")).withMetadata(DefaultComponentMetadataAst.builder().build());
        componentBuilder.withParameter(this.inGroupParameterModel, this.showInDslGroup, (ComponentParameterAst)new DefaultComponentParameterAst("value", this.inGroupParameterModel, this.showInDslGroup, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), new PropertiesResolver(), new ParameterModelUtils()), Optional.empty());
        componentBuilder.withParameterizedModel(this.parameterized);
        componentBuilder.getGenerationInformation().withSyntax((DslElementSyntax)Mockito.mock(DslElementSyntax.class));
        ComponentAst comp = componentBuilder.build();
        MatcherAssert.assertThat((Object)comp.getParameter("Show in DSL", INGROUP_PARAM_NAME).getRawValue(), (Matcher)Matchers.is((Object)"value"));
        MatcherAssert.assertThat((Object)comp.getParameter("Show in DSL", INGROUP_PARAM_NAME).getValue().getRight(), (Matcher)Matchers.is((Object)"value"));
    }

    @Test
    @Issue(value="MULE-18759")
    public void sourceParamCallbacksDisambiguation() {
        BaseComponentAstBuilder componentBuilder = (BaseComponentAstBuilder)ArtifactAstBuilder.builder(Collections.emptySet(), null).addTopLevelComponent().withIdentifier(ComponentIdentifier.buildFromStringRepresentation((String)"ns:comp")).withMetadata(DefaultComponentMetadataAst.builder().build());
        componentBuilder.withParameter(this.inGroupParameterModel, this.showInDslGroup, (ComponentParameterAst)new DefaultComponentParameterAst("value", this.inGroupParameterModel, this.showInDslGroup, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), new PropertiesResolver(), new ParameterModelUtils()), Optional.empty());
        componentBuilder.withParameter(this.inGroupCollidingParameterModel, this.showInDslCollidingGroup, (ComponentParameterAst)new DefaultComponentParameterAst("valueColliding", this.inGroupCollidingParameterModel, this.showInDslCollidingGroup, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), new PropertiesResolver(), new ParameterModelUtils()), Optional.empty());
        componentBuilder.withParameterizedModel((ParameterizedModel)this.sourceParameterized);
        componentBuilder.getGenerationInformation().withSyntax((DslElementSyntax)Mockito.mock(DslElementSyntax.class));
        ComponentAst comp = componentBuilder.build();
        MatcherAssert.assertThat((Object)comp.getParameter("Show in DSL", INGROUP_PARAM_NAME).getRawValue(), (Matcher)Matchers.is((Object)"value"));
        MatcherAssert.assertThat((Object)comp.getParameter("Show in DSL", INGROUP_PARAM_NAME).getValue().getRight(), (Matcher)Matchers.is((Object)"value"));
        MatcherAssert.assertThat((Object)comp.getParameter("Show in DSL Colliding", INGROUP_PARAM_NAME).getRawValue(), (Matcher)Matchers.is((Object)"valueColliding"));
        MatcherAssert.assertThat((Object)comp.getParameter("Show in DSL Colliding", INGROUP_PARAM_NAME).getValue().getRight(), (Matcher)Matchers.is((Object)"valueColliding"));
    }

    @Test(expected=IllegalStateException.class)
    public void duplicateParamSet() {
        BaseComponentAstBuilder componentBuilder = (BaseComponentAstBuilder)ArtifactAstBuilder.builder(Collections.emptySet(), null).addTopLevelComponent().withIdentifier(ComponentIdentifier.buildFromStringRepresentation((String)"ns:comp")).withMetadata(DefaultComponentMetadataAst.builder().build());
        componentBuilder.withParameter(this.flatParameterModel, this.defaultGroup, (ComponentParameterAst)new DefaultComponentParameterAst("value", this.flatParameterModel, this.defaultGroup, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), new PropertiesResolver(), new ParameterModelUtils()), Optional.empty());
        componentBuilder.withParameter(this.flatParameterModel, this.defaultGroup, (ComponentParameterAst)new DefaultComponentParameterAst("value", this.flatParameterModel, this.defaultGroup, (ComponentGenerationInformation)Mockito.mock(ComponentGenerationInformation.class), new PropertiesResolver(), new ParameterModelUtils()), Optional.empty());
    }

    @Test
    @Issue(value="MULE-19156")
    public void extensionModelSet() {
        ExtensionModel nsExtModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)nsExtModel.getName()).thenReturn((Object)"NS");
        Mockito.when((Object)nsExtModel.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setPrefix("ns").build());
        ComponentAst comp = ArtifactAstBuilder.builder(Collections.singleton(nsExtModel), null).addTopLevelComponent().withIdentifier(ComponentIdentifier.buildFromStringRepresentation((String)"ns:comp")).withMetadata(DefaultComponentMetadataAst.builder().build()).build();
        MatcherAssert.assertThat((Object)comp.getExtensionModel(), (Matcher)Matchers.sameInstance((Object)nsExtModel));
    }

    @Test
    @Issue(value="MULE-19363")
    public void metadataTypeSet() {
        ExtensionModel nsExtModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)nsExtModel.getName()).thenReturn((Object)"NS");
        Mockito.when((Object)nsExtModel.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setPrefix("ns").build());
        MetadataType expectedType = (MetadataType)Mockito.mock(MetadataType.class);
        ComponentAst comp = ArtifactAstBuilder.builder(Collections.singleton(nsExtModel), null).addTopLevelComponent().withIdentifier(ComponentIdentifier.buildFromStringRepresentation((String)"ns:comp")).withParameterizedModel((ParameterizedModel)MetadataTypeModelAdapter.createParameterizedTypeModelAdapter((MetadataType)expectedType, null)).withMetadata(DefaultComponentMetadataAst.builder().build()).build();
        MatcherAssert.assertThat((Object)comp.getType(), (Matcher)Matchers.sameInstance((Object)expectedType));
    }

    private static class NonMockParameterModel
    implements ParameterModel {
        private final String name;
        private final MetadataType type;

        public NonMockParameterModel(String name, MetadataType type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public MetadataType getType() {
            return this.type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NonMockParameterModel other = (NonMockParameterModel)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String getDescription() {
            return null;
        }

        public <T extends ModelProperty> Optional<T> getModelProperty(Class<T> propertyType) {
            return Optional.empty();
        }

        public Set<ModelProperty> getModelProperties() {
            return Collections.emptySet();
        }

        public boolean hasDynamicType() {
            return false;
        }

        public Optional<DisplayModel> getDisplayModel() {
            return null;
        }

        public Optional<DeprecationModel> getDeprecationModel() {
            return null;
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isOverrideFromConfig() {
            return false;
        }

        public ExpressionSupport getExpressionSupport() {
            return null;
        }

        public Object getDefaultValue() {
            return null;
        }

        public ParameterDslConfiguration getDslConfiguration() {
            return null;
        }

        public ParameterRole getRole() {
            return null;
        }

        public Optional<LayoutModel> getLayoutModel() {
            return null;
        }

        public List<StereotypeModel> getAllowedStereotypes() {
            return null;
        }

        public Optional<ValueProviderModel> getValueProviderModel() {
            return null;
        }

        public List<FieldValueProviderModel> getFieldValueProviderModels() {
            return Collections.emptyList();
        }

        public boolean isComponentId() {
            return false;
        }

        public Optional<MuleVersion> getMinMuleVersion() {
            return Optional.empty();
        }
    }
}

