/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.api.builder;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.builder.ArtifactAstBuilder;
import org.mule.runtime.ast.internal.DefaultComponentMetadataAst;

@Feature(value="Mule Artifact AST")
@Story(value="AST construction")
public class ArtifactAstBuilderTestCase {
    @Test
    public void buildEmpty() {
        ArtifactAst artifact = ArtifactAstBuilder.builder(Collections.emptySet(), Optional.empty()).build();
        MatcherAssert.assertThat((Object)artifact.topLevelComponentsStream().count(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)artifact.recursiveStream().count(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void buildWithChildren() {
        ArtifactAstBuilder builder = ArtifactAstBuilder.builder(Collections.emptySet(), Optional.empty());
        builder.addTopLevelComponent().withIdentifier(ComponentIdentifier.builder().namespace("ns").name("topLevel1").build()).withParameterizedModel((ParameterizedModel)Mockito.mock(ParameterizedModel.class)).withMetadata(DefaultComponentMetadataAst.builder().build());
        builder.addTopLevelComponent().withIdentifier(ComponentIdentifier.builder().namespace("ns").name("topLevel2").build()).withParameterizedModel((ParameterizedModel)Mockito.mock(ParameterizedModel.class)).withMetadata(DefaultComponentMetadataAst.builder().build()).addChildComponent().withIdentifier(ComponentIdentifier.builder().namespace("ns").name("child").build()).withParameterizedModel((ParameterizedModel)Mockito.mock(ParameterizedModel.class)).withMetadata(DefaultComponentMetadataAst.builder().build());
        ArtifactAst artifact = builder.build();
        MatcherAssert.assertThat((Object)artifact.topLevelComponentsStream().count(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((Object)artifact.recursiveStream().count(), (Matcher)Matchers.is((Object)3L));
    }
}

