/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.AstTraversalDirection;
import org.mule.runtime.ast.internal.FilteredArtifactAst;

@Feature(value="Mule Artifact AST")
@Story(value="AST traversal")
public class FilteredArtifactAstTestCase {
    public static final ComponentIdentifier ON_ERROR_CONTINUE = ComponentIdentifier.builder().namespace("mule").name("on-error-continue").build();
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();
    @Mock
    private ArtifactAst ast;
    @Mock
    private Predicate<ComponentAst> componentFilter;
    @Mock
    private ErrorTypeRepository errorRepo;
    @Mock
    private ComponentAst component;
    @Mock
    private ComponentParameterAst parameterAst;
    @Mock
    private ErrorType parentErrorType;

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void gettingErrorRepositoryWithNoComponentsStillReturnsRepo() {
        ErrorTypeRepository result = new FilteredArtifactAst(this.ast, this.componentFilter, () -> this.errorRepo).getErrorTypeRepository();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void getErrorTypeRepository_oneNode() {
        Mockito.when((Object)this.ast.topLevelComponentsStream()).thenReturn(Stream.of(this.component));
        Mockito.when((Object)this.ast.recursiveStream((AstTraversalDirection)ArgumentMatchers.any())).thenAnswer(invocation -> Stream.of(this.component));
        Mockito.when((Object)this.component.getIdentifier()).thenReturn((Object)ON_ERROR_CONTINUE);
        Mockito.when((Object)this.component.getParameter((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)this.parameterAst);
        Mockito.when((Object)this.parameterAst.getResolvedRawValue()).thenReturn((Object)"foo,bar");
        Mockito.when((Object)this.errorRepo.getAnyErrorType()).thenReturn((Object)this.parentErrorType);
        ErrorTypeRepository result = new FilteredArtifactAst(this.ast, x -> true, () -> this.errorRepo).getErrorTypeRepository();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

