/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ArtifactType;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.api.error.ErrorTypeRepositoryProvider;
import org.mule.runtime.ast.api.util.AstTraversalDirection;
import org.mule.runtime.ast.api.util.BaseArtifactAst;
import org.mule.runtime.ast.internal.error.CompositeErrorTypeRepository;
import org.mule.runtime.ast.internal.error.DefaultErrorTypeRepository;
import org.mule.runtime.ast.internal.error.ErrorTypeRepositoryBuildingUtils;
import org.mule.runtime.ast.internal.model.ExtensionModelHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilteredArtifactAst
extends BaseArtifactAst {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilteredArtifactAst.class);
    private final ArtifactAst fullArtifactAst;
    private final Predicate<ComponentAst> componentFilter;
    private final List<ComponentAst> topLevelComponents;

    public FilteredArtifactAst(ArtifactAst fullArtifactAst, Predicate<ComponentAst> componentFilter) {
        this.fullArtifactAst = fullArtifactAst;
        this.componentFilter = componentFilter;
        this.topLevelComponents = fullArtifactAst.topLevelComponentsStream().filter(componentFilter).collect(Collectors.toList());
    }

    @Override
    public String getArtifactName() {
        return this.fullArtifactAst.getArtifactName();
    }

    @Override
    public ArtifactType getArtifactType() {
        return this.fullArtifactAst.getArtifactType();
    }

    @Override
    public Set<ExtensionModel> dependencies() {
        return this.fullArtifactAst.dependencies();
    }

    @Override
    public Optional<ArtifactAst> getParent() {
        return this.fullArtifactAst.getParent();
    }

    @Override
    public Stream<ComponentAst> recursiveStream(AstTraversalDirection direction) {
        return this.fullArtifactAst.recursiveStream(direction).filter(this.componentFilter);
    }

    @Override
    public List<ComponentAst> topLevelComponents() {
        return this.topLevelComponents;
    }

    @Override
    public void updatePropertiesResolver(UnaryOperator<String> newPropertiesResolver) {
        this.fullArtifactAst.updatePropertiesResolver(newPropertiesResolver);
    }

    @Override
    public Collection<ImportedResource> getImportedResources() {
        return this.fullArtifactAst.getImportedResources();
    }

    @Override
    public ErrorTypeRepository getErrorTypeRepository() {
        LOGGER.debug("Creating errorTypeRepository for Artifact '{}'...", (Object)this);
        DefaultErrorTypeRepository errorTypeRepository = new DefaultErrorTypeRepository();
        Set usedNamespaces = this.recursiveStream().map(comp -> comp.getIdentifier().getNamespaceUri()).collect(Collectors.toSet());
        ErrorTypeRepositoryBuildingUtils.addErrorsFromExtensions(this.fullArtifactAst.dependencies().stream().filter(em -> usedNamespaces.contains(em.getXmlDslModel().getNamespace())).collect(Collectors.toSet()), errorTypeRepository);
        ErrorTypeRepositoryBuildingUtils.addErrorsFromArtifact(this, errorTypeRepository);
        LOGGER.debug("Registering error handlers referenced errorTypes...");
        this.recursiveStream().filter(comp -> comp.getIdentifier().equals(ExtensionModelHelper.ON_ERROR_CONTINUE_IDENTIFIER) || comp.getIdentifier().equals(ExtensionModelHelper.ON_ERROR_PROPAGATE_IDENTIFIER)).flatMap(comp -> {
            String value = comp.getParameter("General", "type").getResolvedRawValue();
            if (value != null) {
                return Arrays.stream(value.split(","));
            }
            return Stream.empty();
        }).map(errorType -> ComponentIdentifier.buildFromStringRepresentation((String)errorType.trim())).filter(errorType -> !errorTypeRepository.lookupErrorType((ComponentIdentifier)errorType).isPresent()).forEach(errorType -> {
            LOGGER.debug("Registering errorType '{}'", errorType);
            errorTypeRepository.addErrorType((ComponentIdentifier)errorType, ErrorTypeRepositoryProvider.getCoreErrorTypeRepo().getAnyErrorType());
        });
        return new CompositeErrorTypeRepository(Arrays.asList(ErrorTypeRepositoryProvider.getCoreErrorTypeRepo(), errorTypeRepository));
    }
}

