/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal;

import java.util.Optional;
import java.util.function.UnaryOperator;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;

public final class DefaultImportedResource
implements ImportedResource {
    private final String resourceLocation;
    private final ComponentMetadataAst metadata;
    private final String resolutionFailure;
    private final PropertiesResolver propertiesResolver = new PropertiesResolver();

    public DefaultImportedResource(String resourceLocation, ComponentMetadataAst metadata) {
        this.resourceLocation = resourceLocation;
        this.metadata = metadata;
        this.resolutionFailure = null;
    }

    public DefaultImportedResource(String resourceLocation, ComponentMetadataAst metadata, String resolutionFailure) {
        this.resourceLocation = resourceLocation;
        this.metadata = metadata;
        this.resolutionFailure = resolutionFailure;
    }

    @Override
    public String getRawResourceLocation() {
        return this.resourceLocation;
    }

    @Override
    public String getResourceLocation() {
        return this.propertiesResolver.apply(this.resourceLocation);
    }

    @Override
    public ComponentMetadataAst getMetadata() {
        return this.metadata;
    }

    @Override
    public Optional<String> getResolutionFailure() {
        return Optional.ofNullable(this.resolutionFailure);
    }

    @Override
    public void updatePropertiesResolver(UnaryOperator<String> propertiesResolver) {
        this.propertiesResolver.setMappingFunction(propertiesResolver);
    }
}

