/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.builder;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesResolver
implements UnaryOperator<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesResolver.class);
    private final List<Runnable> mappingFunctionChangedCallbacks = new ArrayList<Runnable>();
    private UnaryOperator<String> mappingFunction = UnaryOperator.identity();

    @Override
    public String apply(String propertyPlaceHolder) {
        if (propertyPlaceHolder == null) {
            return null;
        }
        LOGGER.trace("Resolving property: '{}'...", (Object)propertyPlaceHolder);
        String value = (String)this.mappingFunction.apply(propertyPlaceHolder);
        if (Objects.equal((Object)propertyPlaceHolder, (Object)value)) {
            LOGGER.trace("Did not resolve property: '{}'");
        } else {
            LOGGER.debug("Resolved property: '{}' to '{}'", (Object)propertyPlaceHolder, (Object)value);
        }
        return value;
    }

    public void setMappingFunction(UnaryOperator<String> mappingFunction) {
        LOGGER.debug("setMappingFunction: '{}'...", mappingFunction);
        this.mappingFunction = mappingFunction;
        this.mappingFunctionChangedCallbacks.forEach(Runnable::run);
    }

    public void onMappingFunctionChanged(Runnable callback) {
        this.mappingFunctionChangedCallbacks.add(callback);
    }
}

