/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.error;

import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.internal.error.ErrorTypeBuilder;

@Story(value="Error types")
public class ErrorTypeBuilderTestCase {
    private static final String NAMESPACE = "CUSTOM";
    private static final String IDENTIFIER = "MY_ERROR";
    private static final String REPRESENTATION = "CUSTOM:MY_ERROR";
    private final ErrorTypeBuilder errorTypeBuilder = ErrorTypeBuilder.builder();
    private final ErrorType mockErrorType = (ErrorType)Mockito.mock(ErrorType.class);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void parentMustBeSet() {
        this.expectException("parent error type cannot be null");
        this.errorTypeBuilder.namespace(NAMESPACE).identifier(IDENTIFIER).build();
    }

    @Test
    public void identifierMustBeSet() {
        this.expectException("string representation cannot be null");
        this.errorTypeBuilder.namespace(NAMESPACE).parentErrorType(this.mockErrorType).build();
    }

    @Test
    public void namespaceMustBeSet() {
        this.expectException("namespace representation cannot be null");
        this.errorTypeBuilder.identifier(IDENTIFIER).parentErrorType(this.mockErrorType).build();
    }

    @Test
    public void createsExpectedTypeAndRepresentation() {
        ErrorType errorType = this.errorTypeBuilder.namespace(NAMESPACE).identifier(IDENTIFIER).parentErrorType(this.mockErrorType).build();
        Assert.assertThat((Object)errorType.getParentErrorType(), (Matcher)Matchers.is((Object)this.mockErrorType));
        Assert.assertThat((Object)errorType.getNamespace(), (Matcher)Matchers.is((Object)NAMESPACE));
        Assert.assertThat((Object)errorType.getIdentifier(), (Matcher)Matchers.is((Object)IDENTIFIER));
        Assert.assertThat((Object)errorType.toString(), (Matcher)Matchers.is((Object)REPRESENTATION));
    }

    private void expectException(String exceptionMessage) {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)exceptionMessage));
    }
}

