/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.builder;

import com.google.common.base.Objects;
import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.DefaultArrayType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.ast.internal.builder.BaseComponentAstBuilder;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;

@Issue(value="MULE-19705")
@Feature(value="Parameter AST resolution")
public class BaseComponentAstBuilderTestCase {
    @Test
    public void testWithParameterRemovesMatchingChildComponent_WhenAddingAParameterThatIsNotShownInDSLAndIsAnElementInsideAnArray() {
        TestComponentAstBuilder testComponentAstBuilder = new TestComponentAstBuilder(new PropertiesResolver());
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        DefaultArrayType componentType = new DefaultArrayType(() -> new DefaultStringType(MetadataFormat.JSON, new HashMap()), MetadataFormat.JSON, new HashMap());
        Mockito.when((Object)parameterModel.getType()).thenReturn((Object)componentType);
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"listParameterModelName");
        DslElementSyntax listElementSyntax = (DslElementSyntax)Mockito.mock(DslElementSyntax.class);
        Mockito.when((Object)listElementSyntax.getElementName()).thenReturn((Object)"list-element-name");
        Mockito.when((Object)listElementSyntax.getPrefix()).thenReturn((Object)"list-prefix");
        Mockito.when((Object)listElementSyntax.getNamespace()).thenReturn((Object)"list-namespace");
        DslElementSyntax componentSyntax = (DslElementSyntax)Mockito.mock(DslElementSyntax.class);
        Mockito.when((Object)componentSyntax.getGeneric((MetadataType)ArgumentMatchers.any(DefaultStringType.class))).thenReturn(Optional.of(listElementSyntax));
        testComponentAstBuilder.getGenerationInformation().withSyntax(componentSyntax);
        BaseComponentAstBuilder component = (BaseComponentAstBuilder)Mockito.mock(BaseComponentAstBuilder.class);
        Mockito.when((Object)component.getIdentifier()).thenReturn((Object)ComponentIdentifier.builder().name("list-element-name").namespace("list-prefix").namespaceUri("list-namespace").build());
        testComponentAstBuilder.addChildComponent(component);
        ComponentParameterAst componentParameterAst = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Optional componentIdentifierOptional = Optional.empty();
        ParameterGroupModel parameterGroupModel = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)parameterGroupModel.isShowInDsl()).thenReturn((Object)false);
        Mockito.when((Object)parameterGroupModel.getParameterModels()).thenReturn(Collections.singletonList(parameterModel));
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Collections.singletonList(parameterGroupModel));
        testComponentAstBuilder.withParameterizedModel(parameterizedModel);
        testComponentAstBuilder.withParameter(parameterModel, parameterGroupModel, componentParameterAst, componentIdentifierOptional);
        testComponentAstBuilder.prepareForBuild();
        MatcherAssert.assertThat((Object)testComponentAstBuilder.childComponentsStream().count(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void testWithParameterRemovesMatchingChildComponent_WhenAddingAParameterThatIsNotShownInDSLAndIsAMap() {
        TestComponentAstBuilder testComponentAstBuilder = new TestComponentAstBuilder(new PropertiesResolver());
        DefaultObjectType objectType = new DefaultObjectType(new ArrayList(), false, null, MetadataFormat.JSON, new HashMap()){

            public <T extends TypeAnnotation> Optional<T> getAnnotation(Class<T> extension) {
                ClassInformationAnnotation classInformationAnnotation = (ClassInformationAnnotation)Mockito.mock(ClassInformationAnnotation.class);
                Mockito.when((Object)classInformationAnnotation.isMap()).thenReturn((Object)true);
                ArrayList<String> genericTypes = new ArrayList<String>();
                genericTypes.add(String.class.getName());
                genericTypes.add(String.class.getName());
                Mockito.when((Object)classInformationAnnotation.getGenericTypes()).thenReturn(genericTypes);
                return Optional.of(classInformationAnnotation);
            }
        };
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getType()).thenReturn((Object)objectType);
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"parameterModelName");
        DslElementSyntax mapSyntax = (DslElementSyntax)Mockito.mock(DslElementSyntax.class);
        Mockito.when((Object)mapSyntax.getElementName()).thenReturn((Object)"element-name");
        Mockito.when((Object)mapSyntax.getPrefix()).thenReturn((Object)"prefix");
        Mockito.when((Object)mapSyntax.getNamespace()).thenReturn((Object)"namespace");
        DslElementSyntax componentSyntax = (DslElementSyntax)Mockito.mock(DslElementSyntax.class);
        Mockito.when((Object)componentSyntax.getChild("parameterModelName")).thenReturn(Optional.of(mapSyntax));
        testComponentAstBuilder.getGenerationInformation().withSyntax(componentSyntax);
        BaseComponentAstBuilder component = (BaseComponentAstBuilder)Mockito.mock(BaseComponentAstBuilder.class);
        Mockito.when((Object)component.getIdentifier()).thenReturn((Object)ComponentIdentifier.builder().name("element-name").namespace("prefix").namespaceUri("namespace").build());
        testComponentAstBuilder.addChildComponent(component);
        ComponentParameterAst componentParameterAst = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Optional componentIdentifierOptional = Optional.empty();
        ParameterGroupModel parameterGroupModel = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)parameterGroupModel.isShowInDsl()).thenReturn((Object)false);
        Mockito.when((Object)parameterGroupModel.getParameterModels()).thenReturn(Collections.singletonList(parameterModel));
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Collections.singletonList(parameterGroupModel));
        testComponentAstBuilder.withParameterizedModel(parameterizedModel);
        testComponentAstBuilder.withParameter(parameterModel, parameterGroupModel, componentParameterAst, componentIdentifierOptional);
        testComponentAstBuilder.prepareForBuild();
        MatcherAssert.assertThat((Object)testComponentAstBuilder.childComponentsStream().count(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    @Issue(value="W-10923083")
    @Description(value="Checks to return the placeholder value when the property resolver can resolve it.")
    public void getComponentIdReturnsThePlaceholderValue() {
        String placeholder = "${key}";
        String placeholderValue = "value";
        PropertiesResolver propertiesResolver = new PropertiesResolver();
        propertiesResolver.setMappingFunction(this.getSimpleMappingFunction());
        TestComponentAstBuilder testComponentAstBuilder = new TestComponentAstBuilder(propertiesResolver);
        LazyValue componentId = new LazyValue(() -> Optional.of("${key}"));
        testComponentAstBuilder.setComponentId((Supplier)componentId);
        MatcherAssert.assertThat(testComponentAstBuilder.getComponentId().get(), (Matcher)Matchers.is((Object)"value"));
    }

    @Test
    @Issue(value="W-10923083")
    @Description(value="Checks to return the placeholder when the property resolver can not resolve it.")
    public void getComponentIdReturnsThePlaceholder() {
        String placeholder = "${KEY}";
        PropertiesResolver propertiesResolver = new PropertiesResolver();
        propertiesResolver.setMappingFunction(this.getSimpleMappingFunction());
        TestComponentAstBuilder testComponentAstBuilder = new TestComponentAstBuilder(propertiesResolver);
        LazyValue componentId = new LazyValue(() -> Optional.of("${KEY}"));
        testComponentAstBuilder.setComponentId((Supplier)componentId);
        MatcherAssert.assertThat(testComponentAstBuilder.getComponentId().get(), (Matcher)Matchers.is((Object)"${KEY}"));
    }

    private UnaryOperator<String> getSimpleMappingFunction() {
        String placeholder = "${key}";
        String placeholderValue = "value";
        return key -> {
            if (Objects.equal((Object)"${key}", (Object)key)) {
                return "value";
            }
            return key;
        };
    }

    private class TestComponentAstBuilder
    extends BaseComponentAstBuilder {
        public TestComponentAstBuilder(PropertiesResolver propertiesResolver) {
            super(propertiesResolver);
        }

        public ComponentAstBuilder addChildComponent() {
            return null;
        }

        public ComponentAst build() {
            return null;
        }

        public ComponentAst get() {
            return null;
        }
    }
}

