/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.xml;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.ast.test.internal.xml.resolver.CachingExtensionSchemaGeneratorTestCase;
import org.mule.runtime.dsl.api.ConfigResource;
import org.mule.runtime.dsl.api.xml.parser.XmlConfigurationDocumentLoader;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.helpers.DefaultHandler;

@Feature(value="Mule Artifact AST")
@Story(value="Artifact XML config parsing")
public class DefaultAstXmlParserTestCase {
    private static final XmlDslModel XML_DSL_MODEL = XmlDslModel.builder().setPrefix("mule").setNamespace("http://mockns").build();
    private ClassLoader classLoader;
    private AstXmlParser parser;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final ExtensionModel mockedExtensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);

    @BeforeClass
    public static void configureTestSchemaLoader() throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        Field schemaGeneratorField = AstXmlParser.Builder.class.getDeclaredField("SCHEMA_GENERATOR");
        schemaGeneratorField.setAccessible(true);
        schemaGeneratorField.set(null, Optional.of(new CachingExtensionSchemaGeneratorTestCase.TestExtensionSchemaGenerator()));
    }

    @Before
    public void before() {
        this.properties.clear();
        this.classLoader = DefaultAstXmlParserTestCase.class.getClassLoader();
        ConstructModel topLevelSimpleConstruct = (ConstructModel)Mockito.mock(ConstructModel.class);
        Mockito.when((Object)topLevelSimpleConstruct.getName()).thenReturn((Object)"top-level-simple");
        ConstructModel topLevelSimpleOtherConstruct = (ConstructModel)Mockito.mock(ConstructModel.class);
        Mockito.when((Object)topLevelSimpleOtherConstruct.getName()).thenReturn((Object)"top-level-simple-other");
        ConstructModel topLevelImportConstruct = (ConstructModel)Mockito.mock(ConstructModel.class);
        Mockito.when((Object)topLevelImportConstruct.getName()).thenReturn((Object)"top-level-import");
        Mockito.when((Object)this.mockedExtensionModel.getName()).thenReturn((Object)"Mock Extension Model");
        Mockito.when((Object)this.mockedExtensionModel.getXmlDslModel()).thenReturn((Object)XML_DSL_MODEL);
        Mockito.when((Object)this.mockedExtensionModel.getConstructModels()).thenReturn(Arrays.asList(topLevelSimpleConstruct, topLevelImportConstruct, topLevelSimpleOtherConstruct));
        this.parser = AstXmlParser.builder().withSchemaValidationsDisabled().withExtensionModel(this.mockedExtensionModel).withPropertyResolver(propertyKey -> this.properties.getOrDefault(propertyKey, propertyKey)).build();
    }

    @Test
    public void simple() {
        ArtifactAst simpleAst = this.parser.parse(new URL[]{this.classLoader.getResource("simple.xml")});
        List components = simpleAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-simple"}));
    }

    @Test
    public void twoConfigs() {
        ArtifactAst twoConfigsAst = this.parser.parse(new URL[]{this.classLoader.getResource("simple.xml"), this.classLoader.getResource("simple-other.xml")});
        List components = twoConfigsAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-simple", "top-level-simple-other"}));
        List imports = twoConfigsAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
        MatcherAssert.assertThat(imports, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void noConfigs() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.parser.parse(new URL[0]));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"At least one 'appXmlConfigUrl' must be provided"));
    }

    @Test
    @Story(value="Artifact XML config DOM processong")
    public void simpleDocuments() {
        Document document = XmlConfigurationDocumentLoader.noValidationDocumentLoader().loadDocument(() -> XMLSecureFactories.createDefault().getSAXParserFactory(), (EntityResolver)new DefaultHandler(), "simple.xml", this.classLoader.getResourceAsStream("simple.xml"), null);
        ArtifactAst simpleAst = this.parser.parseDocument(Arrays.asList(new Pair((Object)"simple.xml", (Object)document)));
        List components = simpleAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-simple"}));
    }

    @Test
    @Story(value="Artifact XML config DOM processong")
    public void twoConfigsDocuments() {
        Document simpleDocument = XmlConfigurationDocumentLoader.noValidationDocumentLoader().loadDocument(() -> XMLSecureFactories.createDefault().getSAXParserFactory(), (EntityResolver)new DefaultHandler(), "simple.xml", this.classLoader.getResourceAsStream("simple.xml"), null);
        Document otherDocument = XmlConfigurationDocumentLoader.noValidationDocumentLoader().loadDocument(() -> XMLSecureFactories.createDefault().getSAXParserFactory(), (EntityResolver)new DefaultHandler(), "simple-other.xml", this.classLoader.getResourceAsStream("simple-other.xml"), null);
        ArtifactAst twoConfigsAst = this.parser.parseDocument(Arrays.asList(new Pair((Object)"simple.xml", (Object)simpleDocument), new Pair((Object)"simple-other.xml", (Object)otherDocument)));
        List components = twoConfigsAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-simple", "top-level-simple-other"}));
        List imports = twoConfigsAst.getImportedResources().stream().map(ImportedResource::getResourceLocation).collect(Collectors.toList());
        MatcherAssert.assertThat(imports, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    @Story(value="Artifact XML config DOM processong")
    public void noDocuments() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.parser.parseDocument(Collections.emptyList()));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"At least one 'appXmlConfigInputStream' must be provided"));
    }

    @Test
    public void parseFromConfigResource() {
        URL resourceURL = this.classLoader.getResource("simple.xml");
        MatcherAssert.assertThat((Object)resourceURL, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        ConfigResource configResource = new ConfigResource(resourceURL);
        ArtifactAst simpleAst = this.parser.parse(new ConfigResource[]{configResource});
        List components = simpleAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-simple"}));
    }

    @Test
    public void parseFromNoConfigResource() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.parser.parse(new ConfigResource[0]));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"At least one 'appXmlConfigResources' must be provided"));
    }

    @Test
    public void parseFromInputStreams() {
        InputStream resourceStream = this.classLoader.getResourceAsStream("simple.xml");
        MatcherAssert.assertThat((Object)resourceStream, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        ArtifactAst simpleAst = this.parser.parse(Collections.singletonList(new Pair((Object)"simple.xml", (Object)resourceStream)));
        List components = simpleAst.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-simple"}));
    }

    @Test
    public void parseFromNoInputStreams() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.parser.parse(Collections.emptyList()));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"At least one 'appXmlConfigInputStream' must be provided"));
    }

    @Test
    @Issue(value="MULE-19534")
    public void legacyFailStrategy() {
        this.parser = AstXmlParser.builder().withPropertyResolver(propertyKey -> this.properties.getOrDefault(propertyKey, propertyKey)).withLegacyFailStrategy().build();
        MuleRuntimeException thrown = (MuleRuntimeException)Assert.assertThrows(MuleRuntimeException.class, () -> this.parser.parse(new URL[]{this.classLoader.getResource("mule-config-schema-missing.xml")}));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"Invalid content was found"));
    }

    @Test
    @Issue(value="MULE-19534")
    public void newFailStrategy() {
        this.parser = AstXmlParser.builder().withPropertyResolver(propertyKey -> this.properties.getOrDefault(propertyKey, propertyKey)).build();
        MuleRuntimeException thrown = (MuleRuntimeException)Assert.assertThrows(MuleRuntimeException.class, () -> this.parser.parse(new URL[]{this.classLoader.getResource("mule-config-schema-missing.xml")}));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"Can't resolve http://www.mulesoft.org/schema/mule/invalid-namespace/current/invalid-schema.xsd, A dependency or plugin might be missing"));
    }

    @Test
    public void parseXmlWithUtf8Bom() {
        ArtifactAst ast = this.parser.parse(new URL[]{this.classLoader.getResource("xml-with-utf8-bom.xml")});
        List components = ast.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-simple"}));
    }

    @Test
    public void parseXmlWithUtf8BomFromInputStream() throws IOException {
        byte[] bomBytes = new byte[]{-17, -69, -65};
        String xmlContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<mule xmlns=\"http://www.mulesoft.org/schema/mule/core\"\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"\n        http://www.mulesoft.org/schema/mule/core http://www.mulesoft.org/schema/mule/core/current/mule.xsd\">\n    <top-level-simple/>\n</mule>";
        byte[] xmlBytes = xmlContent.getBytes(StandardCharsets.UTF_8);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(bomBytes);
        outputStream.write(xmlBytes);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        ArtifactAst ast = this.parser.parse(Collections.singletonList(new Pair((Object)"test-with-bom.xml", (Object)inputStream)));
        MatcherAssert.assertThat((Object)ast, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        List components = ast.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-simple"}));
    }

    @Test
    public void parseMultipleXmlsWithMixedBomPresence() {
        ArtifactAst ast = this.parser.parse(new URL[]{this.classLoader.getResource("simple.xml"), this.classLoader.getResource("xml-with-utf8-bom.xml")});
        List components = ast.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-simple", "top-level-simple"}));
    }

    @Test
    @Story(value="Artifact XML config DOM processong")
    public void parseDocumentWithUtf8Bom() {
        Document document = XmlConfigurationDocumentLoader.noValidationDocumentLoader().loadDocument(() -> XMLSecureFactories.createDefault().getSAXParserFactory(), (EntityResolver)new DefaultHandler(), "xml-with-utf8-bom.xml", this.classLoader.getResourceAsStream("xml-with-utf8-bom.xml"), null);
        ArtifactAst ast = this.parser.parseDocument(Arrays.asList(new Pair((Object)"xml-with-utf8-bom.xml", (Object)document)));
        List components = ast.recursiveStream().map(c -> c.getIdentifier().toString()).collect(Collectors.toList());
        MatcherAssert.assertThat(components, (Matcher)Matchers.contains((Object[])new String[]{"top-level-simple"}));
    }
}

