/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.xml.reader;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapContaining;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.xml.AstXmlParser;

@Feature(value="Mule Artifact AST")
@Story(value="Annotations")
public class XmlAnnotationsTestCase {
    private ClassLoader classLoader;
    private AstXmlParser parser;
    private final Map<String, String> properties = new HashMap<String, String>();

    @Before
    public void before() {
        this.properties.clear();
        this.classLoader = XmlAnnotationsTestCase.class.getClassLoader();
        this.parser = AstXmlParser.builder().withSchemaValidationsDisabled().withPropertyResolver(propertyKey -> this.properties.getOrDefault(propertyKey, propertyKey)).build();
    }

    @Test
    public void annotationsOnCoreElement() {
        ArtifactAst artifact = this.parser.parse(new URL[]{this.classLoader.getResource("mule-config-annotations.xml")});
        ComponentAst flow = (ComponentAst)artifact.topLevelComponents().get(1);
        MatcherAssert.assertThat((String)flow.getAnnotations().toString(), (Object)flow.getAnnotations(), (Matcher)IsMapContaining.hasEntry((Object)"{http://www.mulesoft.org/schema/mule/other-ns}annotation", (Object)"anotherAnnotation"));
    }

    @Test
    @Issue(value="MULE-19683")
    public void annotationsOnSameNamespaceElement() {
        ArtifactAst artifact = this.parser.parse(new URL[]{this.classLoader.getResource("mule-config-annotations.xml")});
        ComponentAst someConfig = (ComponentAst)artifact.topLevelComponents().get(0);
        MatcherAssert.assertThat((String)someConfig.getAnnotations().toString(), (Object)someConfig.getAnnotations(), (Matcher)IsMapContaining.hasEntry((Object)"{http://www.mulesoft.org/schema/mule/other-ns}meta", (Object)"someAnnotation"));
    }

    @Test
    public void documentationWithTag() {
        ArtifactAst artifact = this.parser.parse(new URL[]{this.classLoader.getResource("with-descriptions.xml")});
        ComponentAst documentedFlow = (ComponentAst)artifact.topLevelComponents().get(0);
        MatcherAssert.assertThat((Object)((String)documentedFlow.getMetadata().getDocAttributes().get("description")), (Matcher)Matchers.is((Object)"A flow"));
    }
}

