/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.xml;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.ast.api.ArtifactType;
import org.mule.runtime.ast.api.builder.ArtifactAstBuilder;
import org.mule.runtime.ast.internal.xml.DefaultAstXmlParser;
import org.mule.runtime.dsl.api.ConfigResource;
import org.mule.runtime.dsl.api.xml.parser.XmlConfigurationDocumentLoader;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.helpers.DefaultHandler;

@Feature(value="Mule Artifact AST")
@Story(value="Config parsing cache")
public class AstXmlParserCacheTestCase {
    @Test
    public void byDocumentCache() {
        DefaultAstXmlParser parser = new DefaultAstXmlParser(ArtifactType.APPLICATION, Collections.emptySet(), null, Optional.empty(), p -> p, null);
        Document document = XmlConfigurationDocumentLoader.noValidationDocumentLoader().loadDocument(() -> XMLSecureFactories.createDefault().getSAXParserFactory(), (EntityResolver)new DefaultHandler(), "simple.xml", this.getClass().getClassLoader().getResourceAsStream("simple.xml"), null);
        parser.parseDocument("testApp", Collections.singletonList(new Pair((Object)"simple.xml", (Object)document)));
        try (MockedStatic astBuilder = Mockito.mockStatic(ArtifactAstBuilder.class);){
            parser.parseDocument("testApp", Collections.singletonList(new Pair((Object)"simple.xml", (Object)document)));
            astBuilder.verify(() -> ArtifactAstBuilder.builder((String)ArgumentMatchers.anyString(), (ArtifactType)((ArtifactType)ArgumentMatchers.any()), (Set)ArgumentMatchers.anySet(), (Optional)((Optional)ArgumentMatchers.any()), (UnaryOperator)((UnaryOperator)ArgumentMatchers.any())), Mockito.never());
        }
    }

    @Test
    public void byResourceCache() throws Exception {
        DefaultAstXmlParser parser = new DefaultAstXmlParser(ArtifactType.APPLICATION, Collections.emptySet(), null, Optional.empty(), p -> p, null);
        ConfigResource simpleResource = new ConfigResource("simple.xml", this.getClass().getClassLoader().getResource("simple.xml"));
        parser.parse("testApp", new ConfigResource[]{simpleResource});
        try (MockedStatic astBuilder = Mockito.mockStatic(ArtifactAstBuilder.class);){
            parser.parse("testApp", new ConfigResource[]{simpleResource});
            astBuilder.verify(() -> ArtifactAstBuilder.builder((String)ArgumentMatchers.anyString(), (ArtifactType)((ArtifactType)ArgumentMatchers.any()), (Set)ArgumentMatchers.anySet(), (Optional)((Optional)ArgumentMatchers.any()), (UnaryOperator)((UnaryOperator)ArgumentMatchers.any())), Mockito.never());
        }
    }
}

