/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
/**
 * Mule Artifact AST - Serialization
 * 
 * @moduleGraph
 * @since 1.2
 */
module org.mule.runtime.artifact.ast.xmlParser {
  
  requires org.mule.runtime.api.annotations;
  requires org.mule.runtime.api;
  requires org.mule.runtime.extensions.api;
  requires transitive org.mule.runtime.dsl.api;
  requires transitive org.mule.runtime.artifact.ast;

  requires java.xml;
  
  requires com.github.benmanes.caffeine;
  requires com.google.common;
  requires org.apache.commons.io;
  requires org.apache.commons.lang3;
  requires org.mule.apache.xerces;

  exports org.mule.runtime.ast.api.xml;

  uses org.mule.runtime.dsl.api.xml.XmlNamespaceInfoProvider;
  uses org.mule.runtime.extension.api.dsl.syntax.resources.spi.ExtensionSchemaGenerator;
  
  exports org.mule.runtime.ast.internal.xml to
      org.mule.runtime.extensions.mule.support,
      org.mule.runtime.spring.config;
  exports org.mule.runtime.ast.internal.xml.reader to
      org.mule.runtime.artifact.ast.xmlParser.test;
  exports org.mule.runtime.ast.internal.xml.resolver to
      org.mule.runtime.artifact.ast.xmlParser.test;

}
