/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.xml.resolver;

import io.qameta.allure.Issue;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.ast.internal.xml.resolver.FailAfterTenErrorsResolveEntityFailStrategy;
import org.mule.runtime.ast.internal.xml.resolver.FailOnFirstErrorResolveEntityFailStrategy;
import org.mule.runtime.ast.internal.xml.resolver.ModuleDelegatingEntityResolver;
import org.mule.runtime.ast.internal.xml.resolver.ResolveEntityFailStrategy;
import org.mule.runtime.dsl.internal.util.SchemaMappingsUtils;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.ExtensionSchemaGenerator;
import org.xml.sax.SAXException;

public class ModuleDelegatingEntityResolverTestCase {
    @Test
    public void legacySpring() throws Exception {
        String systemId = SchemaMappingsUtils.resolveSystemId((String)"http://www.springframework.org/schema/beans/spring-beans-current.xsd");
        MatcherAssert.assertThat((Object)systemId, (Matcher)CoreMatchers.is((Object)"http://www.springframework.org/schema/beans/spring-beans.xsd"));
    }

    @Test
    public void failsOnMissing() throws Exception {
        ModuleDelegatingEntityResolver resolver = new ModuleDelegatingEntityResolver(Collections.emptySet(), (ExtensionSchemaGenerator)Mockito.mock(ExtensionSchemaGenerator.class), (DslResolvingContext)Mockito.mock(DslResolvingContext.class), (ResolveEntityFailStrategy)new FailOnFirstErrorResolveEntityFailStrategy());
        Assert.assertThrows((String)"Can't resolve notExists (notExists), A dependency or plugin might be missing", SAXException.class, () -> resolver.resolveEntity("notExists", "notExists"));
    }

    @Test
    @Issue(value="MULE-19534")
    public void notFailsOnMissingIfLegacy() throws Exception {
        ModuleDelegatingEntityResolver resolver = new ModuleDelegatingEntityResolver(Collections.emptySet(), (ExtensionSchemaGenerator)Mockito.mock(ExtensionSchemaGenerator.class), (DslResolvingContext)Mockito.mock(DslResolvingContext.class), (ResolveEntityFailStrategy)new FailAfterTenErrorsResolveEntityFailStrategy());
        resolver.resolveEntity("notExists", "notExists");
    }
}

