/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.xml.resolver;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.ast.internal.xml.DefaultAstXmlParserTestCase;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.ExtensionSchemaGenerator;

public class CachingExtensionSchemaGeneratorTestCase {
    private static int schemaGenerateCounter = 0;
    private ClassLoader classLoader;
    private AstXmlParser parser;
    private final Map<String, String> properties = new HashMap<String, String>();

    @Before
    public void before() {
        schemaGenerateCounter = 0;
        this.properties.clear();
        this.classLoader = DefaultAstXmlParserTestCase.class.getClassLoader();
        ExtensionModel mockHeisenbergModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)mockHeisenbergModel.getName()).thenReturn((Object)"Heisenberg");
        Mockito.when((Object)mockHeisenbergModel.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setNamespace("http://www.mulesoft.org/schema/mule/heisenberg").setSchemaLocation("http://www.mulesoft.org/schema/mule/heisenberg/current/mule-heisenberg.xsd").setPrefix("heisenberg").build());
        this.parser = AstXmlParser.builder().withExtensionModel(mockHeisenbergModel).withPropertyResolver(propertyKey -> this.properties.getOrDefault(propertyKey, propertyKey)).build();
    }

    @Test
    public void generatedSchemaIsCached() {
        this.parser.parse(new URL[]{this.classLoader.getResource("mule-config-with-extension.xml")});
        this.parser.parse(new URL[]{this.classLoader.getResource("mule-config-with-extension.xml")});
        MatcherAssert.assertThat((Object)schemaGenerateCounter, (Matcher)Matchers.is((Object)1));
    }

    public static final class TestExtensionSchemagenerator
    implements ExtensionSchemaGenerator {
        public String generate(ExtensionModel extensionModel, DslResolvingContext context) {
            if (extensionModel.getName().equals("Heisenberg")) {
                schemaGenerateCounter++;
                try {
                    return IOUtils.toString((URL)DefaultAstXmlParserTestCase.class.getClassLoader().getResource("META-INF/heisenberg.xsd"), (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            }
            return "";
        }
    }
}

